package edu.msu.first.parser.gui.wizard;

import java.io.File;
import java.util.Set;

import javax.swing.SwingUtilities;

import edu.msu.first.dataimport.gui.swingfacade.SwingFacade;
import edu.msu.first.wizard.WizardData;
import edu.msu.first.wizard.WizardEvent;
import edu.msu.first.wizard.WizardEventAdapter;
import edu.msu.first.wizard.WizardFrame;

public class Main {

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		SwingFacade.useSystemClassAndFeel();
		SwingUtilities.invokeLater(new Runnable () {
			public void run () {
				Controller controller = new Controller ();
				final WizardFrame frame = new WizardFrame ("Assessment Import", controller);								
				frame.setSize(1024, 768);
				WizardData data = frame.getWizardData();
				data.setProperty(WizardPropertyNames.PDF_FILE, new File ("private/samples/doc10.pdf"));
				frame.addWizardEventListener(new WizardEventAdapter () {
										
					@Override
					public void wizardClosed(WizardEvent e) {
						frame.dispose();
						System.exit (0);
					}	
					
					@Override
					public void wizardCompleted(WizardEvent e) {
						frame.dispose ();
						WizardData data = frame.getWizardData();
						Set<Integer> ignored = (Set<Integer>) data.getProperty(WizardPropertyNames.PAGES_TO_IGNORE);
						for (int page : ignored) {
							System.out.println ("Ignoring page " + page);
						}
						System.exit (0);
					}
				});
				frame.startWizard();
			}
		});		
	}

}
