package edu.msu.first.parser.gui.wizard;

import java.io.File;
import java.util.ArrayList;

import org.apache.log4j.Logger;

import edu.msu.first.parser.assessment.ImageOnPage;
import edu.msu.first.parser.extract.PDFExtract;
import edu.msu.first.wizard.ListWizardController;
import edu.msu.first.wizard.WizardController;
import edu.msu.first.wizard.WizardData;
import edu.msu.first.wizard.WizardPage;

public class Controller extends ListWizardController implements
		WizardController {
	
	private static final Class[] classes = {
		AssessmentFileSelection.class, SelectPagesToIgnore.class,
		VectorImageRasterization.class
	};
	
	private Logger logger;
			
	public Controller () {
		super (classes);
		logger = Logger.getLogger(getClass());
	}
	
	@Override
	public boolean isLastPage(WizardPage currentPage, WizardData data) {		
		if (currentPage instanceof SelectPagesToIgnore) {
			PDFExtract extracter = (PDFExtract) data.getProperty(WizardPropertyNames.PDF_EXTRACT);
			
			/*File pdfFile = (File) data.getProperty(WizardPropertyNames.PDF_FILE);			
			PDFExtract extracter = new PDFExtract (pdfFile.getAbsolutePath());*/
			try {
				/*extracter.extract(pdfFile, null);*/
				ArrayList<ImageOnPage> vectorImages = extracter.getVectorLocations();
				return vectorImages.size() == 0;
			} catch (Exception e) {
				logger.error("Error thrown in Controller attempting to determine whether PDF file has vector graphics", e);
				return true;
			}						
		}			
		else {
			return super.isLastPage(currentPage, data);
		}
	}
	
	
}
