package edu.msu.first.parser.gui.undo;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

import edu.msu.first.parser.gui.MainWindow;
import edu.msu.first.parser.gui.QuestionList;
import edu.msu.first.parser.question.Question;

public class MoveQuestionUndoableEdit extends AbstractUndoableEdit {

	Question question;
	int oldIndex;
	int newIndex;
	
	public MoveQuestionUndoableEdit(Question question, int oldIndex) {
		super();
		this.question = question;
		this.oldIndex = oldIndex;
	}
	
	@Override
	public String getPresentationName() {
		return "move question";
	}
	
	@Override
	public void undo() throws CannotUndoException {
		QuestionList list = MainWindow.getInstance().getQuestionsPane().getQuestionList();
		newIndex = list.indexOfQuestion(question);
		list.removeQuestion(question);
		list.addQuestion(oldIndex, question);
		
		super.undo();
	}
	
	@Override
	public void redo() throws CannotRedoException {
		QuestionList list = MainWindow.getInstance().getQuestionsPane().getQuestionList();
		list.removeQuestion(question);
		list.addQuestion(newIndex, question);
	}
}
