package edu.msu.first.parser.gui.undo;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

import edu.msu.first.parser.question.Question;
import edu.msu.first.parser.question.ResponseItem;

public class AddResponseItemUndoableEdit extends AbstractUndoableEdit {

	Question question;
	ResponseItem ri;
	
	public AddResponseItemUndoableEdit(Question question, ResponseItem ri) {
		super();
		this.question = question;
		this.ri = ri;
	}
	
	@Override
	public String getPresentationName() {
		return "Add ResponseItem";
	}
	
	@Override
	public void undo() throws CannotUndoException {
		question.removeResponseItem(ri);
		super.undo();
	}
	
	@Override
	public void redo() throws CannotRedoException {
		question.addResponseItem(ri);
		super.redo();
	}
}