package edu.msu.first.parser.gui.undo;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

import edu.msu.first.parser.question.Choice;
import edu.msu.first.parser.question.MultipleChoiceResponseItem;

public class AddChoiceUndoableEdit extends AbstractUndoableEdit {

	MultipleChoiceResponseItem responseItem;
	Choice choice;
	
	public AddChoiceUndoableEdit(MultipleChoiceResponseItem responseItem, Choice choice) {
		super();
		this.responseItem = responseItem;
		this.choice = choice;
	}
	
	@Override
	public String getPresentationName() {
		return "add choice";
	}
	
	@Override
	public void undo() throws CannotUndoException {
		responseItem.removeChoice(choice);
		super.undo();
	}
	
	@Override
	public void redo() throws CannotRedoException {
		responseItem.addChoice(choice);
		super.redo();
	}
}
