package edu.msu.first.parser.gui.actions;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;

import edu.msu.first.parser.gui.MainWindow;

/**
 * This action sets all ResponseItem Components to deselected
 * @author bridger.hamilton
 */
public class DeselectAllAction extends AbstractAction {
	private static DeselectAllAction instance;
	
	private DeselectAllAction() {
		super("Deselect All");
	}
	
	/**
	 * @return A singleton instance of DeselectAllAction.
	 */
	public static DeselectAllAction getInstance() {
		if (instance == null) {
			instance = new DeselectAllAction();
		}
		return instance;
	}
	
	public void actionPerformed(ActionEvent e) {
    	MainWindow.getInstance().getQuestionsPane().setAllSelected(false);
	}
}