/**
 *  '$RCSfile: RunAssessmentImportCommand.java,v $'
 *  Copyright: 2000 Regents of the University of California and the
 *              National Center for Ecological Analysis and Synthesis
 *    Authors: @tao@
 *    Release: @release@
 *
 *   '$Author: leinfelder $'
 *     '$Date: 2008/05/27 23:00:12 $'
 * '$Revision: 1.8 $'
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package edu.ucsb.nceas.morpho.first.edml.commands;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;

import org.w3c.dom.Node;

import edu.msu.first.dataimport.gui.PropertyName;
import edu.msu.first.dataimport.gui.RunWizard;
import edu.msu.first.model.IAssessment;
import edu.msu.first.wizard.WizardEvent;
import edu.msu.first.wizard.WizardEventAdapter;
import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.morpho.datapackage.AbstractDataPackage;
import edu.ucsb.nceas.morpho.datapackage.AccessionNumber;
import edu.ucsb.nceas.morpho.datapackage.Entity;
import edu.ucsb.nceas.morpho.datastore.FileSystemDataStore;
import edu.ucsb.nceas.morpho.datastore.MetacatUploadException;
import edu.ucsb.nceas.morpho.first.edml.AssessmentItemUtil;
import edu.ucsb.nceas.morpho.first.plugins.wizard.EdMLWizardSettings;
import edu.ucsb.nceas.morpho.framework.MorphoFrame;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.util.Command;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.utilities.XMLUtilities;

/**
 * Class to handle import data file command
 */
public class RunAssessmentImportCommand implements Command {

	/** A reference to the MophorFrame */
	private MorphoFrame morphoFrame = null;

	/**
	 * Constructor of Import data command
	 */
	public RunAssessmentImportCommand() {

	}// RefreshCommand

	/**
	 * execute refresh command
	 * 
	 * @param event
	 *            ActionEvent
	 */
	public void execute(ActionEvent event) {

		morphoFrame = UIController.getInstance().getCurrentActiveWindow();
		
		//get the current adp
		AbstractDataPackage adp = UIController.getInstance().getCurrentAbstractDataPackage();
		
		//TODO: make the assessment object from the xml
		IAssessment assessment = AssessmentItemUtil.getAssessment(adp);
		final RunWizard runner = new RunWizard(assessment, 800, 600);
		
		runner.addWizardEventListener(
				new WizardEventAdapter() {

					public void wizardCompleted(WizardEvent e) {
						//look up the temp file name
						String fileName = 
							(String) runner.getWizardData().getProperty(PropertyName.ASSESSMENT_DATA_FILE);
						String rowCount = 
							(String) runner.getWizardData().getProperty(PropertyName.ASSESSMENT_DATA_FILE_ROW_COUNT);
						//get the file 
						File f = new File(fileName);
						//insert it into the edml package
						insertDataFile(f, rowCount);
						//remove the artifact
						f.delete();
					}
				});
		
		runner.run();

	}// execute
	
	private void insertDataFile(File f, String rowCount) {
		//get the assessment we are adding data to
		AbstractDataPackage adp = UIController.getInstance().getCurrentAbstractDataPackage();
		
		//set up the template for the entity (attributes etc...)
		Node dataTableNode = null;
		try {
			String lookup = Morpho.getConfiguration().get("dataTableTemplate", 0);
			InputStream template = Morpho.class.getClassLoader().getResourceAsStream(lookup);
			dataTableNode = 
				XMLUtilities.getXMLReaderAsDOMTreeRootNode(
						new InputStreamReader(template));
		} catch (Exception e) {
			e.printStackTrace();
			Log.debug(5, "unexpected error trying to create new XML document");
		}
		
		//only supporting ONE data file right now
		adp.deleteAllEntities();

		//add the data file
		Entity entity = new Entity(dataTableNode, adp);
		adp.addEntity(entity);
		
		//make data a tempfile in cache with an accession number
		String dataFileId = this.saveDataFileAsTemp(f);
		
		//set the metadata about this particular file
		int entityIndex = 0;
		int physicalIndex = 0;
		int distIndex = 0;
		
		String urlS = EdMLWizardSettings.URN_ROOT + dataFileId; //locator for the file (special morpho/metacat format)
		String sizeS = Long.toString(f.length()); //file size in bytes
		String numRecS = rowCount; //passed in as a parameter from the wizard
		
		adp.setDistributionUrl(entityIndex, physicalIndex, distIndex, urlS);
		adp.setPhysicalSize(entityIndex, physicalIndex, sizeS);
		adp.setEntityNumRecords(entityIndex, numRecS);
		
		//these are set in the metadata template
		//String delim = ",";
		//String id = null;
		//adp.setEntityID(entityIndex, id);
		//adp.setPhysicalFieldDelimiter(entityIndex, physicalIndex, delim);
		
		//save it in the datapackage
		try {
			adp.serializeData();
		} catch (MetacatUploadException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		//we changed things, so show the changes
		UIController.showNewPackage(adp);
		
	}
	
	private String saveDataFileAsTemp(File f) {
		AccessionNumber an = new AccessionNumber(Morpho.thisStaticInstance);
		String id = an.getNextId();
		FileSystemDataStore fds = new FileSystemDataStore(
				Morpho.thisStaticInstance);
		try {
			fds.saveTempDataFile(id, new FileInputStream(f));
		} catch (Exception w) {
			Log.debug(1, "error in assessmentWizard saving temp data file!");
		}
		return id;
	}

}// class
