package edu.msu.first.parser.gui.undo;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

import edu.msu.first.parser.gui.MainWindow;
import edu.msu.first.parser.question.Choice;
import edu.msu.first.parser.question.MultipleChoiceResponseItem;
import edu.msu.first.parser.question.Question;

public class DeleteQuestionUndoableEdit extends AbstractUndoableEdit {

	Question question;
	int index;
	
	public DeleteQuestionUndoableEdit(Question question, int index) {
		super();
		this.question = question;
		this.index = index;
	}
	
	@Override
	public String getPresentationName() {
		return "delete question";
	}
	
	@Override
	public void undo() throws CannotUndoException {
		MainWindow.getInstance().getQuestionsPane().getQuestionList().addQuestion(index, question);
		super.undo();
	}
	
	@Override
	public void redo() throws CannotRedoException {
		MainWindow.getInstance().getQuestionsPane().getQuestionList().removeQuestion(index);
		super.redo();
	}
}
