package edu.msu.first.parser.gui.undo;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

import edu.msu.first.parser.gui.CategoryComponent;
import edu.msu.first.parser.question.ResponseItem;
import edu.msu.first.parser.question.VocabItem;

public class DeleteCategoryUndoableEdit extends AbstractUndoableEdit {

	private ResponseItem responseItem;
	private VocabItem category;
	private int index;
	
	public DeleteCategoryUndoableEdit(ResponseItem responseItem, VocabItem category,int index) {
		super();
		this.responseItem = responseItem;
		this.category = category;
		this.index = index;
	}
	
	@Override
	public String getPresentationName() {
		return "delete category";
	}
	
	/**
	 * NOTE: This does not preserve the order of the deleted category! If it's important to do so,
	 * a clone of the ResponseItem's entire metadata map will have to be stored instead of a VocabItem.
	 */
	@Override
	public void undo() throws CannotUndoException {
		responseItem.addMetadataItem(CategoryComponent.KEY, category,index);
		super.undo();
	}
	
	@Override
	public void redo() throws CannotRedoException {
		responseItem.removeMetadataItem(CategoryComponent.KEY, category);
		super.redo();
	}
}