package edu.msu.first.parser.gui.actions;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;

import edu.msu.first.parser.gui.MainWindow;

/**
 * This action sets all ResponseItem Components to selected
 * @author bridger.hamilton
 */
public class SelectAllAction extends AbstractAction {
	private static SelectAllAction instance;
	
	private SelectAllAction() {
		super("Select All");
	}
	
	/**
	 * @return A singleton instance of SelectAllAction.
	 */
	public static SelectAllAction getInstance() {
		if (instance == null) {
			instance = new SelectAllAction();
		}
		return instance;
	}
	
	public void actionPerformed(ActionEvent e) {
    	MainWindow.getInstance().getQuestionsPane().setAllSelected(true);
	}
}