package edu.msu.first.parser.gui.actions;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;

/**
 * Action for going to the previous page of the original document
 * shown in the PDF pane.
 * @author garrison.benson
 *
 */
public class ExitAction extends AbstractAction {

	private static ExitAction instance;
	
	private ExitAction() {
		super("Exit");
	}
	
	/**
	 * @return A singleton instance of PreviousPageAction.
	 */
	public static ExitAction getInstance() {
		if (instance == null) {
			instance = new ExitAction();
		}
		return instance;
	}
	
	/**
	 * Turns to the previous page of the PDF document.
	 * @param e The ActionEvent. No particular action command is needed.
	 */
	public void actionPerformed(ActionEvent e) {
		// TODO: Make this check if the user has saved, etc.
		System.exit(0);
	}

}
