package edu.msu.first.parser.gui.actions;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.ImageIcon;

import edu.msu.first.parser.gui.MainWindow;
import edu.msu.first.parser.gui.undo.DeleteChoiceUndoableEdit;
import edu.msu.first.parser.question.Choice;
import edu.msu.first.parser.question.MultipleChoiceResponseItem;

/**
 * <code>Action</code> for when the user deletes one of the choices (AKA foils). One instance
 * of this <code>Action</code> exists for each <code>Answer</code> in each <code>Question</code>.
 * @author Garrison Benson
 */
public class DeleteChoiceAction extends AbstractAction {

	private MultipleChoiceResponseItem responseItem;
	private Choice choice;
	
	/**
	 * @param questionComponent The <code>QuestionComponent</code> from which the <code>Answer</code> will be removed, and the <code>Answer</code> to be removed.
	 */
	public DeleteChoiceAction(MultipleChoiceResponseItem responseItem, Choice choice) {
		super("Delete choice", new ImageIcon(MainWindow.getInstance().getClass().getResource("Delete16.gif")));
		this.responseItem = responseItem;
		this.choice = choice;
	}
	
	/**
	 * @param e The ActionEvent. No particular action command is needed.
	 */
	public void actionPerformed(ActionEvent e) {
		int index = responseItem.indexOfChoice(choice);
		responseItem.removeChoice(choice);
		MainWindow.getInstance().getUndoMediator().addEdit(new DeleteChoiceUndoableEdit(responseItem, choice, index));
	}

}
