package edu.msu.first.parser.gui.actions;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;

import edu.msu.first.parser.gui.MainWindow;
import edu.msu.first.parser.question.Question;

/**
 * Action for when the user is in "Choose from source" mode and
 * he/she clicks "Done".
 * @author Garrison Benson
 */
public class ChooseFromSourceDoneAction extends AbstractAction {
	
	private static ChooseFromSourceDoneAction instance;
	
	public static ChooseFromSourceDoneAction getInstance() {
		if (instance == null) {
			instance = new ChooseFromSourceDoneAction();
		}
		return instance;
	}
	
	private ChooseFromSourceDoneAction() {
		super("Done");
	}
	
	public void actionPerformed(ActionEvent e) {
		String text = MainWindow.getInstance().getOriginalDocumentPane().getSelectedText();
		Question question = MainWindow.getInstance().getQuestionsPane().getChooseFromSourceQuestion();
		question.parse(text, question.getType());
		
		MainWindow.getInstance().setMode(MainWindow.MODE_STANDARD);
		MainWindow.getInstance().getQuestionsPane().setChooseFromSourceQuestion(null);
	}

}
