package edu.msu.first.parser.gui.actions;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.JComboBox;

import edu.msu.first.parser.question.Question;
import edu.msu.first.parser.question.QuestionCompositeType;
import edu.msu.first.parser.question.QuestionType;
import edu.msu.first.parser.question.ResponseItemType;

public class ChangeQuestionTypeAction extends AbstractAction {
	
	private Question question;
	private JComboBox comboBox;
	private JComboBox riComboBox;
	
	public ChangeQuestionTypeAction(Question question, JComboBox questionTypeComboBox, JComboBox responseItemTypeComboBox) {
		super();
		this.question = question;
		this.comboBox = questionTypeComboBox;
		this.riComboBox = responseItemTypeComboBox;
	}
	
	public void actionPerformed(ActionEvent e) {
		
		QuestionCompositeType qct = (QuestionCompositeType) comboBox.getSelectedItem();
		ResponseItemType rit = (ResponseItemType) riComboBox.getSelectedItem();
		
		QuestionType typeForParser;
		
		if (qct == QuestionCompositeType.MULTI_PART)
			typeForParser = QuestionType.MULTI_PART;
		else if (rit == ResponseItemType.FILL_IN_THE_BLANK)
			typeForParser = QuestionType.FILL_IN_THE_BLANK;
		else if (rit == ResponseItemType.IMAGE_HOTSPOT)
			typeForParser = QuestionType.IMAGE_HOTSPOT;
		else if (rit == ResponseItemType.MULTIPLE_CHOICE)
			typeForParser = QuestionType.MULTIPLE_CHOICE;
		else if (rit == ResponseItemType.TRUE_FALSE)
			typeForParser = QuestionType.TRUE_FALSE;
		else
			typeForParser = QuestionType.SHORT_ANSWER;
		
		// TODO: Figure out why the following doesn't work:
		
		question.parse(question.getOriginalText(), typeForParser);
		//question.parse(question.getOriginalText(), (QuestionType) comboBox.getSelectedItem());
		//MainWindow.getInstance().getUndoMediator().addEdit(new ChangeQuestionTypeUndoableEdit(question));
	}
	
	public void updateResponseItemTypeComboBox(JComboBox box) {
		this.riComboBox = box;
	}

}
