/**
 *  '$RCSfile: EditCourseCommand.java,v $'
 *  Copyright: 2000 Regents of the University of California and the
 *              National Center for Ecological Analysis and Synthesis
 *    Authors: Saurabh Garg
 *    Release: @release@
 *
 *   '$Author: leinfelder $'
 *     '$Date: 2008/05/27 23:00:12 $'
 * '$Revision: 1.4 $'
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package edu.ucsb.nceas.morpho.first.edml.commands;

import java.awt.event.ActionEvent;
import java.util.List;

import javax.xml.transform.TransformerException;

import org.apache.xerces.dom.DOMImplementationImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

import edu.ucsb.nceas.morpho.datapackage.AbstractDataPackage;
import edu.ucsb.nceas.morpho.first.plugins.wizard.EdMLWizardInterface;
import edu.ucsb.nceas.morpho.framework.AbstractUIPage;
import edu.ucsb.nceas.morpho.framework.ModalDialog;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.plugins.DataPackageWizardInterface;
import edu.ucsb.nceas.morpho.plugins.ServiceController;
import edu.ucsb.nceas.morpho.plugins.ServiceNotHandledException;
import edu.ucsb.nceas.morpho.util.Command;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.morpho.util.UISettings;
import edu.ucsb.nceas.utilities.OrderedMap;
import edu.ucsb.nceas.utilities.XMLUtilities;

/**
 * Class to handle add course command
 */
public class EditCourseCommand implements Command {

	// generic name for lookup in edml listings
	private final String COURSE_GENERIC_NAME = "course";

	public EditCourseCommand() {
	}

	/**
	 * execute add command
	 * 
	 * @param event
	 *            ActionEvent
	 */
	public void execute(ActionEvent event) {

		adp = UIController.getInstance().getCurrentAbstractDataPackage();
		exsitingCourseRoot = adp.getSubtrees(COURSE_GENERIC_NAME);

		if (showCourseDialog()) {

			try {
				insertCourse();
				UIController.showNewPackage(adp);
			} catch (Exception w) {
				Log.debug(15, "Exception trying to modify course DOM: " + w);
				w.printStackTrace();
				Log.debug(5, "Unable to add course details!");
			}
		} else {
			// gets here if user has pressed "cancel" on dialog...
			// ////////////////////

			// Restore project subtree to state it was in when we started...
			adp.deleteAllSubtrees(COURSE_GENERIC_NAME);
			if (!exsitingCourseRoot.isEmpty()) {
				Object nextXPathObj = null;
				int count = exsitingCourseRoot.size();
				DOMImplementation impl = 
					DOMImplementationImpl.getDOMImplementation();
				for (int i = count - 1; i > -1; i--) {
					courseRoot = (Node) exsitingCourseRoot.get(i);
					Node check = 
						adp.insertSubtree(COURSE_GENERIC_NAME, courseRoot, 0);
					if (check != null) {
						Log.debug(45, "added new creator details to package...");
					} else {
						Log.debug(5, "** ERROR: Unable to add new creator details to package **");
					}
				}
			}
		}

	}

	private boolean showCourseDialog() {

		ServiceController sc;
		DataPackageWizardInterface dpwPlugin = null;
		try {
			sc = ServiceController.getInstance();
			dpwPlugin = 
				(DataPackageWizardInterface) sc.getServiceProvider(DataPackageWizardInterface.class);

		} catch (ServiceNotHandledException se) {

			Log.debug(6, se.getMessage());
			se.printStackTrace();
		}
		if (dpwPlugin == null) {
			return false;
		}

		coursePage = dpwPlugin.getPage(EdMLWizardInterface.COURSE_PAGE);

		Node courseNode = adp.getSubtree(COURSE_GENERIC_NAME, 0);
		OrderedMap existingValuesMap = 
			XMLUtilities.getDOMTreeAsXPathMap(courseNode);

		Log.debug(45, "sending previous data to coursePage -\n\n"
				+ existingValuesMap);

		boolean pageCanHandleAllData = 
			coursePage.setPageData(existingValuesMap, "/" + COURSE_GENERIC_NAME);

		ModalDialog dialog = null;
		if (pageCanHandleAllData) {

			dialog = 
				new ModalDialog(
						coursePage, 
						UIController.getInstance().getCurrentActiveWindow(), 
						UISettings.POPUPDIALOG_WIDTH,
						UISettings.POPUPDIALOG_HEIGHT);
		} else {

			UIController.getInstance().launchEditorAtSubtreeForCurrentFrame(
					COURSE_GENERIC_NAME, 0);
			return false;
		}

		return (dialog.USER_RESPONSE == ModalDialog.OK_OPTION);
	}

	private void insertCourse() {

		OrderedMap map = coursePage.getPageData("/" + COURSE_GENERIC_NAME);
		Log.debug(45, "\n insertCourse() Got course details from "
				+ "course page -\n" + map.toString());

		if (map == null) {
			Log.debug(5, "Unable to get course details from input!");
			return;
		} else if (map.isEmpty()) {
			Log.debug(45, "Replacing all course details!");
		}

		DOMImplementation impl = DOMImplementationImpl.getDOMImplementation();
		Document doc = impl.createDocument("", COURSE_GENERIC_NAME, null);
		courseRoot = doc.getDocumentElement();
		
		//add default edml NS
		Attr nsAttribute = doc.createAttribute("xmlns");
		nsAttribute.setNodeValue("edml://ecoinformatics.org/edml");
		((Element)courseRoot).setAttributeNode(nsAttribute);
		
		//add an lom namespace prefix mapping so that the map can be converted to DOM
		Attr lomAtt = doc.createAttribute("xmlns:lom");
		lomAtt.setNodeValue("http://ltsc.ieee.org/xsd/LOM");
		((Element)courseRoot).setAttributeNode(lomAtt);
		
		try {
			XMLUtilities.getXPathMapAsDOMTree(map, courseRoot);
		} catch (TransformerException w) {
			Log.debug(5, "Unable to add course details to package!");
			Log.debug(15,
						"TransformerException ("
								+ w
								+ ") calling "
								+ "XMLUtilities.getXPathMapAsDOMTree(map, courseRoot) with \n"
								+ "map = " + map + " and course = "
								+ courseRoot);
			w.printStackTrace();
			return;
		}

		// delete old course from datapackage
		adp.deleteAllSubtrees(COURSE_GENERIC_NAME);
		
		//psych! remove the namespace before inserting into the rest of the tree
		((Element)courseRoot).removeAttributeNode(nsAttribute);
		((Element)courseRoot).removeAttributeNode(lomAtt);
		
		// add to the datapackage
		Node check = adp.insertSubtree(COURSE_GENERIC_NAME, courseRoot, 0);
		if (check != null) {
			Log.debug(45, "added new course details to package...");
		} else {
			Log.debug(5,
					"** ERROR: Unable to add new course details to package **");
		}

	}

	private List exsitingCourseRoot;
	private Node courseRoot;
	private AbstractDataPackage adp;
	private AbstractUIPage coursePage;
}
