package edu.msu.first.parser.gui.undo;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import edu.msu.first.parser.question.TextAndImage;


public class ImageChangeUndoableEdit extends AbstractUndoableEdit {

	private TextAndImage model1;
	private List<String> oldImage1;
	private List<String> newImage1;
	private TextAndImage model2;
	private List<String> oldImage2;
	private List<String> newImage2;
	private TextAndImage model;

	public ImageChangeUndoableEdit(TextAndImage model1, List<String> oldImage1,List<String> newImage1, TextAndImage model2, List<String> oldImage2, List<String> newImage2) {
		super();
		this.model1 = model1;
		this.oldImage1 = oldImage1;
		this.newImage1 = newImage1;
		this.model2 = model2;
		this.oldImage2 = oldImage2;
		this.newImage2 = newImage2;
		
	}
	
	public ImageChangeUndoableEdit(TextAndImage model, List<String> oldImage, List<String> newImage) {
		this(model, oldImage, newImage, null, null, null);
	}
	
	@Override
	public String getPresentationName() {
		if (model2 != null) {
			return "move image";
		}
		else {
			return "change image";
		}
	}
	
	@Override
	public void undo() throws CannotUndoException {
		if (model1!=null)
			model1.setImageList(newImage1);
		
		if (model2 != null) {
			
		}
		super.undo();
	}
	
	@Override
	public void redo() throws CannotRedoException {
		if (model1!=null)
			
		model1.setImageList(oldImage1);
		if (model2 != null) {
	
		}
		super.redo();
	}

}
