/**
 *  '$RCSfile: RunAssessmentParseCommand.java,v $'
 *  Copyright: 2000 Regents of the University of California and the
 *              National Center for Ecological Analysis and Synthesis
 *    Authors: @tao@
 *    Release: @release@
 *
 *   '$Author: mcfall $'
 *     '$Date: 2008/07/10 12:54:18 $'
 * '$Revision: 1.8 $'
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package edu.ucsb.nceas.morpho.first.edml.commands;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.util.concurrent.Executors;

import javax.swing.JFrame;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

import edu.msu.first.parser.gui.MainWindow;
import edu.msu.first.wizard.WizardEvent;
import edu.msu.first.wizard.WizardEventAdapter;
import edu.msu.first.wizard.WizardEventListener;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.util.Command;
import edu.ucsb.nceas.morpho.util.Log;

/**
 * Class to handle import data file command
 */
public class RunAssessmentParseCommand implements Command {

	/** A reference to the MophorFrame */
	private JFrame parent = null;

	/**
	 * Constructor of Import data command
	 */
	public RunAssessmentParseCommand() {

	}// RefreshCommand

	/**
	 * execute refresh command
	 * 
	 * @param event
	 *            ActionEvent
	 */
	public void execute(ActionEvent event) {
		
	    //use a new thread for the parser?
	    Executors.newSingleThreadExecutor().submit(new Runnable() {

			public void run() {
				try {
					UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
				}
			    catch (Exception e) {}
			    			    								
				WizardEventListener eventListener = new WizardEventAdapter () {
					@Override
					public void wizardCanceled(WizardEvent e) {
						super.wizardCanceled(e);
					}

					@Override
					public void wizardClosed(WizardEvent e) {						
						super.wizardClosed(e);
					}

					@Override
					public void wizardCompleted(WizardEvent e) {
						MainWindow.getInstance().setVisible(true);
						MainWindow.getInstance().toFront();
					}
					
				};
				
				try {
					MainWindow.getInstance().chooseAndImportFile(eventListener);
				} catch (Exception e) {
					Log.debug(5, "Could not launch the parser");
				}
			} // run
	    });
	    


	}// execute

}// class
