/**
 *  '$RCSfile: AssessmentParseWizardCommand.java,v $'
 *  Copyright: 2000 Regents of the University of California and the
 *              National Center for Ecological Analysis and Synthesis
 *    Authors: Saurabh Garg
 *    Release: @release@
 *
 *   '$Author: leinfelder $'
 *     '$Date: 2008/06/12 23:07:12 $'
 * '$Revision: 1.4 $'
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package edu.ucsb.nceas.morpho.first.edml.commands;

import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.List;

import javax.xml.transform.TransformerException;

import org.apache.xerces.dom.DOMImplementationImpl;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

import edu.ucsb.nceas.morpho.datapackage.AbstractDataPackage;
import edu.ucsb.nceas.morpho.first.plugins.wizard.EdMLWizardInterface;
import edu.ucsb.nceas.morpho.framework.AbstractUIPage;
import edu.ucsb.nceas.morpho.framework.ModalDialog;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.plugins.DataPackageWizardInterface;
import edu.ucsb.nceas.morpho.plugins.ServiceController;
import edu.ucsb.nceas.morpho.plugins.ServiceNotHandledException;
import edu.ucsb.nceas.morpho.util.Command;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.morpho.util.UISettings;
import edu.ucsb.nceas.utilities.OrderedMap;
import edu.ucsb.nceas.utilities.XMLUtilities;

/**
 * Class to handle add instructor command
 * @deprecated Please launch the parser directly using RunAssessmentParseCommand rather than stopping on a wizard page.
 */
public class AssessmentParseWizardCommand implements Command {

	// generic name for lookup in edml listings
	private final String ASSESSMENT_ITEMS_GENERIC_NAME = "assessmentItems";

	public AssessmentParseWizardCommand() {
	}

	/**
	 * execute add command
	 * 
	 * @param event
	 *            ActionEvent
	 */
	public void execute(ActionEvent event) {

		adp = UIController.getInstance().getCurrentAbstractDataPackage();

		if (showParserDialog()) {

			try {
				//insertAssessmentItems();
				UIController.showNewPackage(adp);
			} catch (Exception w) {
				Log.debug(
						15,
						"Exception trying to modify assessment items DOM: "
						+ w);
				w.printStackTrace();
				Log.debug(5, "Unable to add assessment item details!");
			}
		} else {
			// gets here if user has pressed "cancel" on dialog...
			// ////////////////////

			// Restore project subtree to state it was in when we started...
			// adp.deleteAllSubtrees(ASSESSMENT_ITEMS_GENERIC_NAME);

		}

	}

	private boolean showParserDialog() {

		ServiceController sc;
		DataPackageWizardInterface dpwPlugin = null;
		try {
			sc = ServiceController.getInstance();
			dpwPlugin = (DataPackageWizardInterface) sc
					.getServiceProvider(DataPackageWizardInterface.class);

		} catch (ServiceNotHandledException se) {

			Log.debug(6, se.getMessage());
			se.printStackTrace();
		}
		if (dpwPlugin == null) {
			return false;
		}

		parserPage = 
			dpwPlugin.getPage(EdMLWizardInterface.ASSESSMENT_PARSER_PAGE);

		OrderedMap existingValuesMap = new OrderedMap();

		List assessmentItemsList = 
			adp.getSubtrees(ASSESSMENT_ITEMS_GENERIC_NAME);

		if (!assessmentItemsList.isEmpty()) {			
			Iterator listIt = assessmentItemsList.iterator();
			Object nextObj = null;

			while (listIt.hasNext()) {
				nextObj = listIt.next();
				existingValuesMap = 
					XMLUtilities.getDOMTreeAsXPathMap((Node) nextObj);
				//just use the one and only first item
				break;
			}
		}

		Log.debug(45, "sending previous data to parserPage -\n\n"
				+ existingValuesMap);

		boolean pageCanHandleAllData = 
			parserPage.setPageData(
					existingValuesMap, 
					"/" + ASSESSMENT_ITEMS_GENERIC_NAME);

		ModalDialog dialog = null;
		if (pageCanHandleAllData) {

			dialog = 
				new ModalDialog(
					parserPage, 
					UIController.getInstance().getCurrentActiveWindow(), 
					UISettings.POPUPDIALOG_WIDTH,
					UISettings.POPUPDIALOG_HEIGHT,
					false);
			//need this to be non-modal so that the parser can be used...
			dialog.setModal(false);
			dialog.setVisible(true);
		} else {

			return false;
		}

		return (dialog.USER_RESPONSE == ModalDialog.OK_OPTION);
	}

	private AbstractDataPackage adp;
	private AbstractUIPage parserPage;
}
