/**
 *  '$RCSfile: AddInstitutionCommand.java,v $'
 *  Copyright: 2000 Regents of the University of California and the
 *              National Center for Ecological Analysis and Synthesis
 *    Authors: Saurabh Garg
 *    Release: @release@
 *
 *   '$Author: leinfelder $'
 *     '$Date: 2008/03/28 19:26:49 $'
 * '$Revision: 1.1 $'
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package edu.ucsb.nceas.morpho.first.edml.commands;

import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import javax.xml.transform.TransformerException;

import org.apache.xerces.dom.DOMImplementationImpl;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

import edu.ucsb.nceas.morpho.datapackage.AbstractDataPackage;
import edu.ucsb.nceas.morpho.first.plugins.wizard.EdMLWizardInterface;
import edu.ucsb.nceas.morpho.framework.AbstractUIPage;
import edu.ucsb.nceas.morpho.framework.ModalDialog;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.plugins.DataPackageWizardInterface;
import edu.ucsb.nceas.morpho.plugins.ServiceController;
import edu.ucsb.nceas.morpho.plugins.ServiceNotHandledException;
import edu.ucsb.nceas.morpho.util.Command;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.morpho.util.UISettings;
import edu.ucsb.nceas.utilities.OrderedMap;
import edu.ucsb.nceas.utilities.XMLUtilities;

/**
 * Class to handle add institution command
 */
public class AddInstitutionCommand
    implements Command {

  //generic name for lookup in edml listings
  private final String INSTITUTION_GENERIC_NAME = "institution";

  public AddInstitutionCommand() {}

  /**
   * execute add command
   *
   * @param event ActionEvent
   */
  public void execute(ActionEvent event) {

    adp = UIController.getInstance().getCurrentAbstractDataPackage();
    exsitingInstitutionRoot =
        adp.getSubtrees(INSTITUTION_GENERIC_NAME);

    if (showInstitutionDialog()) {

      try {
        insertInstitution();
        UIController.showNewPackage(adp);
      }
      catch (Exception w) {
        Log.debug(15, "Exception trying to modify institution DOM: " + w);
        w.printStackTrace();
        Log.debug(5, "Unable to add institution details!");
      }
    } else {
      //gets here if user has pressed "cancel" on dialog... ////////////////////

      //Restore project subtree to state it was in when we started...
      adp.deleteAllSubtrees(INSTITUTION_GENERIC_NAME);
      if (!exsitingInstitutionRoot.isEmpty()) {
        Object nextXPathObj = null;

        int count = exsitingInstitutionRoot.size();
        DOMImplementation impl = DOMImplementationImpl.getDOMImplementation();
        for (int i = count - 1; i > -1; i--) {
          institutionRoot = (Node) exsitingInstitutionRoot.get(i);
          Node check = adp.insertSubtree(
        		  INSTITUTION_GENERIC_NAME,
              institutionRoot, 0);
          if (check != null) {
            Log.debug(45, "added new creator details to package...");
          } else {
            Log.debug(5,
                "** ERROR: Unable to add new creator details to package **");
          }

        }
      }
    }

  }

  private boolean showInstitutionDialog() {

    ServiceController sc;
    DataPackageWizardInterface dpwPlugin = null;
    try {
      sc = ServiceController.getInstance();
      dpwPlugin = (DataPackageWizardInterface) sc.getServiceProvider(
    		  DataPackageWizardInterface.class);

    }
    catch (ServiceNotHandledException se) {

      Log.debug(6, se.getMessage());
      se.printStackTrace();
    }
    if (dpwPlugin == null) {
      return false;
    }

    institutionPage = dpwPlugin.getPage(EdMLWizardInterface.INSTITUTION_MAIN_PAGE);

    OrderedMap existingValuesMap = new OrderedMap();

    List institutionList = adp.getSubtrees(
    		INSTITUTION_GENERIC_NAME);

    if (!institutionList.isEmpty()) {
      Iterator listIt = institutionList.iterator();
      Object nextObj = null;
      Object nextTempObj = null;
      String nextTempString = null;
      int count = 1;

      while (listIt.hasNext()) {
        nextObj = listIt.next();
        OrderedMap tempMap = XMLUtilities.getDOMTreeAsXPathMap( (Node) nextObj);
        Iterator tempIt = tempMap.keySet().iterator();
        while (tempIt.hasNext()) {
          nextTempObj = tempIt.next();
          nextTempString = (String) nextTempObj;
          if (nextTempString != null) {
            existingValuesMap.put("/"
                + INSTITUTION_GENERIC_NAME + "["
                + count + "]" + nextTempString.substring(
                		INSTITUTION_GENERIC_NAME.length() + 1,
                nextTempString.length()),
                tempMap.get(nextTempObj));
          }
        }
        count++;
      }
    }

    Log.debug(45, "sending previous data to institutionPage -\n\n"
        + existingValuesMap);

    boolean pageCanHandleAllData
        = institutionPage.setPageData(existingValuesMap, "/" + INSTITUTION_GENERIC_NAME);

    ModalDialog dialog = null;
    if (pageCanHandleAllData) {

      dialog = new ModalDialog(institutionPage,
          UIController.getInstance().
          getCurrentActiveWindow(),
          UISettings.POPUPDIALOG_WIDTH,
          UISettings.POPUPDIALOG_HEIGHT);
    } else {

      UIController.getInstance().launchEditorAtSubtreeForCurrentFrame(
    		  INSTITUTION_GENERIC_NAME, 0);
      return false;
    }

    return (dialog.USER_RESPONSE == ModalDialog.OK_OPTION);
  }

  private void insertInstitution() {

    OrderedMap map = institutionPage.getPageData("/" + INSTITUTION_GENERIC_NAME + "[");
    Log.debug(45,
        "\n insertInstitution() Got institution details from "
        + "institution page -\n" + map.toString());

    if (map == null) {
      Log.debug(5, "Unable to get institution details from input!");
      return;
    } else if (map.isEmpty()) {
      Log.debug(45, "Deleting all institution details!");
    }

    DOMImplementation impl = DOMImplementationImpl.getDOMImplementation();
    //delete old title from datapackage
    adp.deleteAllSubtrees(INSTITUTION_GENERIC_NAME);

    Iterator institutionIt = map.keySet().iterator();
    Object nextXPathObj = null;
    String nextXPath = null;
    HashMap institutionSetMap = new HashMap();

    while (institutionIt.hasNext()) {
      nextXPathObj = institutionIt.next();
      if (nextXPathObj == null) {
        continue;
      }
      nextXPath = (String) nextXPathObj;

      String temp = nextXPath.substring(
    		  INSTITUTION_GENERIC_NAME.length()
          + 2, nextXPath.length());
      temp = temp.substring(0, temp.indexOf("]"));
      nextXPath = nextXPath.replaceFirst(temp, "1");

      if (institutionSetMap.containsKey(temp)) {
        OrderedMap institutionMap = (OrderedMap) institutionSetMap.get(
            temp);
        institutionMap.put(nextXPath, map.get(nextXPathObj));
      } else {
        OrderedMap institutionMap = new OrderedMap();
        institutionMap.put(nextXPath, map.get(nextXPathObj));
        institutionSetMap.put(temp, institutionMap);
      }
    }

    Iterator institutionSetIt = institutionSetMap.keySet().iterator();
    while (institutionSetIt.hasNext()) {
      nextXPathObj = institutionSetIt.next();
      OrderedMap institutionMap = (OrderedMap) institutionSetMap.get(
          nextXPathObj);
      Document doc = impl.createDocument("", INSTITUTION_GENERIC_NAME, null);
      institutionRoot = doc.getDocumentElement();

      try {
        XMLUtilities.getXPathMapAsDOMTree(institutionMap,
            institutionRoot);
      }
      catch (TransformerException w) {
        Log.debug(5, "Unable to add institution details to package!");
        Log.debug(15, "TransformerException (" + w + ") calling "
            +
            "XMLUtilities.getXPathMapAsDOMTree(map, institutionRoot) with \n"
            + "map = " + map
            + " and institution = " + institutionRoot);
        return;
      }

      // add to the datapackage
      Node check = adp.insertSubtree(INSTITUTION_GENERIC_NAME,
          institutionRoot,
          0);
      if (check != null) {
        Log.debug(45, "added new institution details to package...");
      } else {
        Log.debug(5,
            "** ERROR: Unable to add new institution details to package **");
      }
    }
  }

  private List exsitingInstitutionRoot;
  private Node institutionRoot;
  private AbstractDataPackage adp;
  private AbstractUIPage institutionPage;
}
