package edu.msu.first.parser.gui.wizard;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

import javax.swing.JCheckBox;

import edu.msu.first.parser.assessment.ImageOnPage;
import edu.msu.first.parser.extract.PDFExtract;
import edu.msu.first.parser.gui.PDFPane;
import edu.msu.first.wizard.WizardData;

public class SelectPagesToIgnore extends PanelWithPDFPane implements PropertyChangeListener {

	public enum ComponentNames {
		CHECKBOX_IGNORE_PAGE
	}
	
	private JCheckBox cbxIgnoreThisPage;		
	private Set<Integer> pagesToIgnore;	
	
	public SelectPagesToIgnore(WizardData data) {
		super(data, true);						
	}
	
	@Override
	protected void createPanelGUI() {
		super.createPanelGUI();
												
		cbxIgnoreThisPage = factory.createJCheckBox(ComponentNames.CHECKBOX_IGNORE_PAGE, "Ignore this page");
		cbxIgnoreThisPage.setToolTipText("Select this box if this page should be ignored when extracting questions from the assessment");

		int currentPage = pdfPane.getCurrentPageNumber();
		cbxIgnoreThisPage.setSelected(pdfPane.isPageIgnored(currentPage));
						
		bodyPanel.add(pdfPane, "growx, growy, wrap");
		bodyPanel.add(cbxIgnoreThisPage, "align left");	
						
		setupListeners ();
	}
	
	private void setupListeners () {
		pdfPane.addPropertyChangeListener(PDFPane.PROPERTY_PAGE_NUMBER, this);
		
		cbxIgnoreThisPage.addActionListener(new ActionListener () {
			public void actionPerformed(ActionEvent e) {
				/*if (cbxIgnoreThisPage.isSelected()) {
					pagesToIgnore.add(pdfPane.getCurrentPageNumber());
				}
				else {
					pagesToIgnore.remove(pdfPane.getCurrentPageNumber());
				}*/
				pdfPane.setIgnorePage(pdfPane.getCurrentPageNumber(), cbxIgnoreThisPage.isSelected());
				repaint ();
			}			
		});
	}
	@Override
	protected String getPanelInstructions() {
		StringBuffer instructions = new StringBuffer (1024);
		instructions.append ("Some assessments contain entire pages of material which are not questions (for example, instructions or equation reference sheets).");
		instructions.append ("<p>If you have such pages, use the controls below to navigate to those pages and then click on the checkbox labeled <b>Ignore this page</b>.</p>");
		instructions.append ("<p>Click next when you have completed this task</p>");
		return instructions.toString();
	}

	public String getPageTitle() {
		return "Select pages to ignore";
	}

	public void saveValues(WizardData data) {
		super.saveValues(data);
		data.setProperty(WizardPropertyNames.PDF_PANE, pdfPane);
		data.setProperty(WizardPropertyNames.PAGES_TO_IGNORE, pdfPane.getPagesToIgnore());		
	}

	public void propertyChange(PropertyChangeEvent evt) {
		int pageNumber = (Integer) evt.getNewValue();
		cbxIgnoreThisPage.setSelected(pdfPane.isPageIgnored(pageNumber));		
		repaint ();		
	}

	@Override
	public boolean isFinishEnabledInitially() {
		//  If there are vector images, we don't want the user to click finish here; they must identify 
		//  the vector images for us
		PDFExtract extractor = (PDFExtract) wizardData.getProperty(WizardPropertyNames.PDF_EXTRACT);
		ArrayList<ImageOnPage> images = extractor.getVectorLocations();		
		return (images.size() == 0);
	}

	@Override
	public boolean isNextEnabledInitially() {
		return true;
	}
}
