package edu.msu.first.parser.gui.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;

import edu.msu.first.parser.gui.ExtractedQuestionsPane;
import edu.msu.first.parser.gui.MainWindow;
import edu.msu.first.parser.gui.undo.UndoMediator;


public class UndoAction extends AbstractAction {

	private static UndoAction instance;
	
	private UndoAction() {
		super("Undo", new ImageIcon(MainWindow.getInstance().getClass().getResource("Undo16.gif")));
		setEnabled(false);
	}
	
	public static UndoAction getInstance() {
		if (instance == null) {
			instance = new UndoAction();
		}
		return instance;
	}
	
	public void actionPerformed(ActionEvent e) {
		UndoMediator undoMediator = MainWindow.getInstance().getUndoMediator();
		undoMediator.undo();
		undoMediator.updateUndoActions();
	}
}
