package edu.msu.first.parser.gui.actions;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.ImageIcon;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import edu.msu.first.parser.gui.MainWindow;
import edu.ucsb.nceas.morpho.first.edml.AssessmentItemUtil;

/**
 * Action for adding a new <code>Question</code>. For now, it's added at the end of the document.
 * @author Garrison Benson
 *
 */
public class SaveDocumentAction extends AbstractAction {

	public static Log log = LogFactory.getLog(SaveDocumentAction.class);
	
	private static SaveDocumentAction instance;
	
	private SaveDocumentAction() {
		super("Save and close", new ImageIcon(MainWindow.getInstance().getClass().getResource("Save16.gif")));
	}
	
	/**
	 * @return A singleton instance of AddQuestionAction.
	 */
	public static SaveDocumentAction getInstance() {
		if (instance == null) {
			instance = new SaveDocumentAction();
		}
		return instance;
	}
	
	/**
	 * Load a new PDF document.
	 */
	public void actionPerformed(ActionEvent e) {
		//persist the items in the parser to the morpho editor
		AssessmentItemUtil.persistParserStateToMorpho();
		
		//goodbye!
		MainWindow.getInstance().dispose();
	}

}
