package edu.msu.first.parser.gui.actions;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.ImageIcon;

import edu.msu.first.parser.gui.MainWindow;
import edu.msu.first.parser.gui.undo.DeleteResponseItemUndoableEdit;
import edu.msu.first.parser.question.Question;
import edu.msu.first.parser.question.ResponseItem;

/**
 * <code>Action</code> for when the user deletes one of the ResponseItems. One instance
 * of this <code>Action</code> exists for each <code>ResponseItem</code> in each <code>Question</code>.
 * @author Bridger Hamilton
 */
public class DeleteResponseItemAction extends AbstractAction {

	private Question question;
	private ResponseItem ri;
	
	/**
	 * @param questionComponent The <code>Question</code> from which the <code>ResponseItem</code> will be removed, and the <code>Answer</code> to be removed.
	 */
	public DeleteResponseItemAction(Question question,ResponseItem ri) {
		super("Delete choice", new ImageIcon(MainWindow.getInstance().getClass().getResource("Delete16.gif")));
		this.question = question;
		this.ri = ri;
	}
	
	/**
	 * @param e The ActionEvent. No particular action command is needed.
	 */
	public void actionPerformed(ActionEvent e) {
		int index = question.indexOfResponseItem(ri);
		question.removeResponseItem(ri);
		MainWindow.getInstance().getUndoMediator().addEdit(new DeleteResponseItemUndoableEdit(question, ri, index));
	}

}
