package edu.msu.first.parser.gui.actions;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;

import edu.msu.first.parser.gui.MainWindow;
import edu.msu.first.parser.gui.undo.AddResponseItemUndoableEdit;
import edu.msu.first.parser.question.Question;
import edu.msu.first.parser.question.ResponseItem;
import edu.msu.first.parser.question.ShortAnswerResponseItem;

/**
 * <code>Action</code> to add a new, blank <code>ResponseItem</code> to a <code>Question</code>. One instance
 * of this <code>Action</code> exists for each <code>Question</code>.
 * @author Bridger Hamilton
 *
 */
public class AddResponseItemAction extends AbstractAction {

	private Question question;
	
	/**
	 * @param questionComponent The <code>Question</code> to which the new <code>ResponseItem</code> will be added.
	 */
	public AddResponseItemAction(Question question) {
		super("Add Response Item");
		this.question = question;
	}
	
	/**
	 * @param e The <code>ActionEvent</code>. No particular action command is needed.
	 */
	public void actionPerformed(ActionEvent e) {
		ResponseItem newRI = new ShortAnswerResponseItem();
		question.addResponseItem(newRI);
		MainWindow.getInstance().getUndoMediator().addEdit(new AddResponseItemUndoableEdit(question,newRI));
	}

}
