<?xml version="1.0"?>
<!--
	*  '$RCSfile: qti-root.xsl,v $'
	*      Authors: leinfelder
	*    Copyright: 2000 Regents of the University of California and the
	*               National Center for Ecological Analysis and Synthesis
	*  For Details: http://www.nceas.ucsb.edu/
	*
	*   '$Author: leinfelder $'
	*     '$Date: 2008/05/28 22:40:06 $'
	* '$Revision: 1.2 $'
	*
	* This program is free software; you can redistribute it and/or modify
	* it under the terms of the GNU General Public License as published by
	* the Free Software Foundation; either version 2 of the License, or
	* (at your option) any later version.
	*
	* This program is distributed in the hope that it will be useful,
	* but WITHOUT ANY WARRANTY; without even the implied warranty of
	* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	* GNU General Public License for more details.
	*
	* You should have received a copy of the GNU General Public License
	* along with this program; if not, write to the Free Software
	* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
	*
	* This is an XSLT (http://www.w3.org/TR/xslt) stylesheet designed to
	* convert an XML file that is valid with respect to the edml.xsd
	* module of the Educational Metadata Language (EdML) into an HTML format
	* suitable for rendering with modern web browsers.
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:fn="http://www.w3.org/2005/02/xpath-function"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="1.0">

	<!-- config the css styles -->
	<xsl:import href="edml-settings.xsl" />
	
	<!--  import the supporting templates -->
	<xsl:import href="edml-qti.xsl"/>
	
	<xsl:output method="html" encoding="iso-8859-1"
		doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN"
		doctype-system="http://www.w3.org/TR/html4/loose.dtd" indent="yes" />

	<xsl:template match="/">
		<html>
			<head>
				<title>Assessment Item Metadata</title>
				<link rel="stylesheet" type="text/css"
					href="{$stylePath}/{$qformat}/{$qformat}.css">
				</link>
				<script language="Javascript" type="text/JavaScript"
					src="{$stylePath}/{$qformat}/{$qformat}.js">
				</script>
				<script language="Javascript" type="text/JavaScript"
					src="{$styleCommonPath}/branding.js">
				</script>
				<script language="Javascript" type="text/JavaScript"
					src="{$styleCommonPath}/prototype-1.5.1.1/prototype.js">
				</script>
			</head>
			<body>

				<div id="{$mainTableAligmentStyle}">
					<script language="JavaScript"
						type="text/JavaScript">
						<xsl:if test="$insertTemplate='0'">
							<xsl:comment>
								insertTemplateOpening();//
							</xsl:comment>
						</xsl:if>
						<xsl:if test="$insertTemplate='1'">
							insertTemplateOpening();
						</xsl:if>
					</script>


					<table xsl:use-attribute-sets="cellspacing" class="{$mainContainerTableStyle}">
						<xsl:apply-templates select="*[local-name()='questestinterop']" />
					</table>
					<script language="JavaScript"
						type="text/JavaScript">
						<xsl:if test="$insertTemplate='0'">
							<xsl:comment>
								insertTemplateClosing();//
							</xsl:comment>
						</xsl:if>
						<xsl:if test="$insertTemplate='1'">
							insertTemplateClosing();
						</xsl:if>
					</script>
				</div>
			</body>
		</html>
	</xsl:template>

	<xsl:template match="*[local-name()='questestinterop']">
		<tr valign="top">
			<td colspan="2">&#160;</td>
		</tr>
		<tr valign="top">
			<th colspan="2" class="tablehead">Assessment Item Details</th>
		</tr>	
		<tr valign="top">
			<td colspan="2">
				<xsl:for-each select="assessment/section/item">
					<xsl:call-template name="question" />
				</xsl:for-each>
			</td>
		</tr>
		
		<tr valign="top">
			<td colspan="2">&#160;</td>
		</tr>
		<tr valign="top">
			<th colspan="2">Containing Assessments</th>
		</tr>
		
		<tr valign="top">
			<td colspan="1" width="50px">&#160;</td>
			<td colspan="1">
				<xsl:for-each select="assessment/section/item">
					<xsl:call-template name="containingAssessments" />
				</xsl:for-each>
			</td>
		</tr>
		
	</xsl:template>
	
	<xsl:template name="containingAssessments">
		<div id="ajaxResults">Loading Containing Assessments...</div>
		<script type="text/javascript" language="Javascript">
			<![CDATA[
			function generateSearchString(assessmentItemId) {
				var query = 
					"<pathquery version='1.2'>"
					     +"<querytitle>Containing-Assessment-Search</querytitle>"
					     
					     +"<returndoctype>edml://ecoinformatics.org/edml</returndoctype>"
					     //+"<returndoctype>http://www.imsglobal.org/xsd/ims_qtiasiv1p2</returndoctype>"
					     
                         
                         +"<returnfield>assessment/@title</returnfield>"
                         +"<returnfield>assessment/@id</returnfield>"
                         +"<returnfield>assessment/duration</returnfield>"
                         +"<returnfield>lom/general/title/string</returnfield>"
                         +"<returnfield>lom/general/keyword/string</returnfield>"
                         +"<returnfield>individualName/surName</returnfield>"
                         +"<returnfield>organizationName</returnfield>"
					     
					     +"<querygroup operator='UNION'>";
					    
					    //add the assessmentId 
					    query +=
					     		"<queryterm searchmode='contains' casesensitive='false'>"
					                  +"<value>"
					                  + assessmentItemId
					                  +"</value>"
					                  +"<pathexpr>assessmentItemId</pathexpr>"
					          +"</queryterm>";
						
					    //close the query group      
					     query +=
					     "</querygroup>"
					+"</pathquery>";
				return query;	
			}
			
			function callAjax(myQuery) {
				var metacatURL = "]]><xsl:value-of select="$servletPath" /><![CDATA[";
																				
				//alert("calling ajax: " + metacatURL);
				//alert("myQuery: " + myQuery);
				
				//var myRequest = new Ajax.Request(
				var myUpdate = new Ajax.Updater(
					'ajaxResults',
					metacatURL,
					{	method: 'post',
						parameters: { action: 'squery', qformat: 'first-assessment', query: myQuery},
						evalScripts: true, 
						//onSuccess: function(transport) {alert('success: ' + transport.status);},
						onFailure: function(transport) {alert('failure making ajax call');}
					 });
					 
				 //alert("done calling ajax");
			}
			//get the id and generate the query string
			var myId ="]]><xsl:value-of select="@ident"/><![CDATA[";]]><![CDATA[
			var myQuery = generateSearchString(myId);
			callAjax(myQuery);
		 ]]>	
		</script>
	
	</xsl:template>
	
</xsl:stylesheet>
