package edu.msu.first.parser.gui.wizard;

public enum WizardPropertyNames {
	/**
	 * The PDF file that we are currently working with, as a java.io.File object
	 */
	PDF_FILE,
	/**
	 * This is an object of the type PDFExtract, representing the extracted content of the file
	 * referenced by PDF_FILE.
	 */
	PDF_EXTRACT,
	/**
	 * This is an IPDFPane object that represents the PDF document being examined.  We store it here in the wizard data
	 * to avoid having to reconstruct it on each page of the wizard, since that is a time consuming process.
	 */
	PDF_PANE,
	/**
	 * This is a java.util.Set<Integer> containing the page numbers that should be ignored
	 */
	PAGES_TO_IGNORE,
	/**
	 * This is a java.util.List<ImageOnPage> of those images that were indicated by the user as vector images
	 */
	RASTERIZED_IMAGES
}
