package edu.msu.first.parser.gui.wizard;

import java.awt.Component;
import java.io.File;
import java.util.Set;

import javax.swing.JRootPane;

import edu.msu.first.dataimport.gui.BasePanel;
import edu.msu.first.parser.gui.PDFPane;
import edu.msu.first.wizard.WizardData;

public abstract class PanelWithPDFPane extends BasePanel {
		
	protected PDFPane pdfPane;
				
	/**
	 * Constructs a page containing a PDF panel
	 * @param data the WizardData object associated with the wizard
	 * @param paintIgnoredPages a flag that indicates whether or not pages
	 * marked as ignored have an indicator marking them as such painted.
	 */
	public PanelWithPDFPane(WizardData data, boolean paintIgnoredPages) {
		super(data);	
		setMarkIgnoredPages(paintIgnoredPages);
	}
			
	@Override
	protected void createPanelGUI() {
		if (wizardData.isPropertySet(WizardPropertyNames.PDF_PANE)) {
			pdfPane = (PDFPane) wizardData.getProperty(WizardPropertyNames.PDF_PANE);
			pdfPane.setMarkIgnoredPages(true);
			pdfPane.jumpToPage(1);
		}
		else {
			pdfPane = new PDFPane ();
			pdfPane.setMarkIgnoredPages(true);
			File file = (File) wizardData.getProperty(WizardPropertyNames.PDF_FILE);
			pdfPane.openFile(file);
		}
	}
	
	public void saveValues (WizardData data) {
		pdfPane.setMarkIgnoredPages(false);
	}
	
	public boolean isMarkIngoredPages() {
		return pdfPane.isMarkIgnoredPages();
	}

	/**
	 * Specifies whether pages marked as ignored are painted
	 * with a visual indicator to show they are being ignored
	 * @param markIgnoredPages true if ignored pages should be
	 * painted specially, false otherwise
	 */
	public void setMarkIgnoredPages(boolean markIgnoredPages) {
		pdfPane.setMarkIgnoredPages(markIgnoredPages);
	}
}
