package edu.msu.first.parser.gui.wizard;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.HashSet;

import javax.swing.JOptionPane;

import edu.msu.first.dataimport.gui.BasePanel;
import edu.msu.first.dataimport.gui.FileSelectionPanel;
import edu.msu.first.parser.extract.PDFExtract;
import edu.msu.first.parser.gui.PDFFileFilter;
import edu.msu.first.wizard.WizardData;

public class AssessmentFileSelection extends BasePanel {

	private FileSelectionPanel fileSelectionPanel;
	private String currentFileName;
	
	public AssessmentFileSelection(WizardData data) {
		super(data);		
	}

	@Override
	protected void createPanelGUI() {
		fileSelectionPanel = new FileSelectionPanel ();
		PDFFileFilter fileFilter = new PDFFileFilter ();
		fileSelectionPanel.setFileFilter(fileFilter);
		fileSelectionPanel.addComponents(bodyPanel);
		
		if (wizardData.isPropertySet(WizardPropertyNames.PDF_FILE)) {
			File f = (File) wizardData.getProperty(WizardPropertyNames.PDF_FILE);
			currentFileName = f.getAbsolutePath();
		}
		
		fileSelectionPanel.addFileListener(new PropertyChangeListener () {
			public void propertyChange(PropertyChangeEvent event) {
				String newFile = fileSelectionPanel.getFileName();
												
				fireButtonStateChange(WIZARD_PROPERTY.NEXT_BUTTON_STATE, true);	
				
				//  Clear out the set of pages that are set to ignore if we choose a new file
				if (currentFileName != null && !currentFileName.equals(newFile)) {
					wizardData.setProperty(WizardPropertyNames.PAGES_TO_IGNORE, new HashSet<Integer> ());
					currentFileName = newFile;
				}
			}			
		});
		
		if (wizardData.isPropertySet(WizardPropertyNames.PDF_FILE)) {
			File currentFile = (File) wizardData.getProperty(WizardPropertyNames.PDF_FILE);
			fileSelectionPanel.setFileName(currentFile.getAbsolutePath());
		}
	}

	@Override
	protected String getPanelInstructions() {
		return "Select the PDF file that contains the assessment you would like to import";
	}

	public String getPageTitle() {
		return "Choose assessment file";
	}

	public void saveValues(WizardData data) {
		File newFile = new File(fileSelectionPanel.getFileName());
		if (data.isPropertySet(WizardPropertyNames.PDF_FILE)) {
			File oldFile = (File) data.getProperty(WizardPropertyNames.PDF_FILE);
			if (!oldFile.getAbsolutePath().equals(newFile.getAbsolutePath())) {
				for (WizardPropertyNames name : WizardPropertyNames.values()) {
					data.removeProperty(name);
				}
			} 			
		}
		
		data.setProperty(WizardPropertyNames.PDF_FILE, newFile);
		
		if (!data.isPropertySet(WizardPropertyNames.PDF_EXTRACT)) {
			//  Run PDFExtract so that object is available for other pages to use
			PDFExtract extractor = new PDFExtract (newFile.getAbsolutePath());
			try {
				extractor.extract(newFile, null);
			} catch (Exception e) {
				logger.fatal("Error extracting text of file " + newFile.getAbsolutePath(), e);
				JOptionPane.showMessageDialog(
						this, "An error occurred trying to extract the text of the file " + newFile.getName() + ".\nThe import process cannot continue", 
						"Error extracting text", JOptionPane.ERROR_MESSAGE);
			}

			data.setProperty(WizardPropertyNames.PDF_EXTRACT, extractor);
		}
	}

	@Override
	public boolean isFinishEnabledInitially() {
		return wizardData.isPropertySet(WizardPropertyNames.PDF_FILE);
	}

	@Override
	public boolean isNextEnabledInitially() {
		return wizardData.isPropertySet(WizardPropertyNames.PDF_FILE);
	}

	
}
