package edu.msu.first.parser.gui.undo;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

import edu.msu.first.parser.question.Question;
import edu.msu.first.parser.question.ResponseItem;

public class DeleteResponseItemUndoableEdit extends AbstractUndoableEdit {

	Question question;
	ResponseItem ri;
	int index;
	
	public DeleteResponseItemUndoableEdit(Question question, ResponseItem ri, int index) {
		super();
		this.question = question;
		this.ri = ri;
		this.index = index;
	}
	
	@Override
	public String getPresentationName() {
		return "delete responseItem";
	}
	
	@Override
	public void undo() throws CannotUndoException {
		question.addResponseItem(index, ri);
		super.undo();
	}
	
	@Override
	public void redo() throws CannotRedoException {
		question.removeResponseItem(ri);
		super.redo();
	}
}
