package edu.msu.first.parser.gui.actions;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.ImageIcon;

import edu.msu.first.parser.gui.MainWindow;

/**
 * Action for adding a new <code>Question</code>. For now, it's added at the end of the document.
 * @author Garrison Benson
 *
 */
public class NewDocumentAction extends AbstractAction {

	private static NewDocumentAction instance;
	
	private NewDocumentAction() {
		super("Select PDF document", new ImageIcon(MainWindow.getInstance().getClass().getResource("New16.gif")));
	}
	
	/**
	 * @return A singleton instance of AddQuestionAction.
	 */
	public static NewDocumentAction getInstance() {
		if (instance == null) {
			instance = new NewDocumentAction();
		}
		return instance;
	}
	
	/**
	 * Load a new PDF document.
	 */
	public void actionPerformed(ActionEvent e) {
		//MainWindow.getInstance().chooseAndImportFile();
	}

}
