package edu.msu.first.parser.gui.actions;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;

import edu.msu.first.parser.gui.MainWindow;
import edu.msu.first.parser.gui.undo.AddChoiceUndoableEdit;
import edu.msu.first.parser.question.Choice;
import edu.msu.first.parser.question.MultipleChoiceResponseItem;

/**
 * <code>Action</code> to add a new, blank choice (foil) to a <code>Question</code>. One instance
 * of this <code>Action</code> exists for each <code>Question</code>.
 * @author Garrison Benson
 *
 */
public class AddChoiceAction extends AbstractAction {

	private MultipleChoiceResponseItem responseItem;
	
	/**
	 * @param questionComponent The <code>Question</code> to which the new <code>Answer</code> will be added.
	 */
	public AddChoiceAction(MultipleChoiceResponseItem responseItem) {
		super("Add choice");
		this.responseItem = responseItem;
	}
	
	/**
	 * @param e The <code>ActionEvent</code>. No particular action command is needed.
	 */
	public void actionPerformed(ActionEvent e) {
		Choice newChoice = new Choice();
		responseItem.addChoice(newChoice);
		MainWindow.getInstance().getUndoMediator().addEdit(new AddChoiceUndoableEdit(responseItem, newChoice));
	}

}
