/**
 *  '$RCSfile: HelpMetadataIntroCommand.java,v $'
 *  Copyright: 2000 Regents of the University of California and the
 *              National Center for Ecological Analysis and Synthesis
 *    Authors: @authors@
 *    Release: @release@
 *
 *   '$Author: leinfelder $'
 *     '$Date: 2008/05/09 20:05:37 $'
 * '$Revision: 1.1 $'
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package edu.ucsb.nceas.morpho.first.edml.commands;

import edu.ucsb.nceas.morpho.framework.HTMLBrowser;
import edu.ucsb.nceas.morpho.framework.MorphoFrame;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.util.Command;

import java.awt.event.ActionEvent;


public class HelpMetadataIntroCommand implements Command {


  private final String INITIAL_URL
      = "file:///" + System.getProperty("user.dir")
        + "/docs/user/edml/index.html";


  public HelpMetadataIntroCommand() {}

  public void execute(ActionEvent ae) {

    MorphoFrame frame
        = UIController.getInstance().addWindow("Introduction to Educational Metadata Language (EdML)");

    HTMLBrowser viewer = new HTMLBrowser(frame, false);

    viewer.loadNewPage(INITIAL_URL);

    viewer.setVisible(true);
  }
}
