package edu.msu.first.parser.gui.actions;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.ImageIcon;

import edu.msu.first.parser.gui.MainWindow;
import edu.msu.first.parser.gui.QuestionList;
import edu.msu.first.parser.gui.undo.DeleteQuestionUndoableEdit;
import edu.msu.first.parser.question.Question;

/**
 * <code>Action</code> for when the user deletes one of the <code>Question</code>s. One instance
 * of this <code>Action</code> exists for each <code>Question</code>.
 * @author Garrison Benson
 */
public class DeleteQuestionAction extends AbstractAction {

	private Question question;
	
	/**
	 * @param questionComponent The <code>QuestionComponent</code> to be deleted.
	 */
	public DeleteQuestionAction(Question question) {
		super("Delete question", new ImageIcon(MainWindow.getInstance().getClass().getResource("Delete16.gif")));
		this.question = question;
	}
	
	/**
	 * @param e The ActionEvent. No particular action command is needed.
	 */
	public void actionPerformed(ActionEvent e) {
		QuestionList list = MainWindow.getInstance().getQuestionsPane().getQuestionList();
		int index = list.indexOfQuestion(question);
		list.removeQuestion(question);
		MainWindow.getInstance().getUndoMediator().addEdit(new DeleteQuestionUndoableEdit(question, index));
	}

}
