package edu.msu.first.parser.gui.actions;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;

import edu.msu.first.parser.gui.MainWindow;

/**
 * Action for when the user is in "Choose from source" mode and he/she
 * clicks "Cancel".
 * @author Garrison Benson
 */
public class ChooseFromSourceCancelAction extends AbstractAction {
	
	private static ChooseFromSourceCancelAction instance;
	
	public static ChooseFromSourceCancelAction getInstance() {
		if (instance == null) {
			instance = new ChooseFromSourceCancelAction();
		}
		return instance;
	}
	
	private ChooseFromSourceCancelAction() {
		super("Cancel");
	}
	
	public void actionPerformed(ActionEvent e) {
		
		MainWindow.getInstance().setMode(MainWindow.MODE_STANDARD);
		MainWindow.getInstance().getQuestionsPane().setChooseFromSourceQuestion(null);
	}

}
