package edu.msu.first.parser.gui.actions;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.JComboBox;

import edu.msu.first.parser.question.*;

public class ChangeResponseItemTypeAction extends AbstractAction {
	
	private ResponseItem responseItem;
	private JComboBox comboBox;
	private Question question;
	
	public ChangeResponseItemTypeAction(ResponseItem responseItem, Question question) {
		super();
		this.responseItem = responseItem;
		this.question = question;
	}
	
	/**
	 * This method MUST be called before this action is added to a component!
	 * @param comboBox
	 */
	public void setComboBox(JComboBox comboBox){
		this.comboBox = comboBox;
	}
	
	public void actionPerformed(ActionEvent e) {
		
		// TODO: Add 'Undo' functionality
		int index = question.indexOfResponseItem(responseItem);
		question.removeResponseItem(responseItem);
		
		// Create a new response item of the correct type
		ResponseItem newItem = new ShortAnswerResponseItem(); // default to short answer
		ResponseItemType type = (ResponseItemType)comboBox.getSelectedItem();
		if(type.equals(ResponseItemType.FILL_IN_THE_BLANK)){
			newItem = new FillInTheBlankResponseItem();
			if (question.getType() != QuestionType.MULTI_PART)
				question.setType(QuestionType.FILL_IN_THE_BLANK);
		}else if(type.equals(ResponseItemType.IMAGE_HOTSPOT)){
			newItem = new ImageHotSpotResponseItem();
			if (question.getType() != QuestionType.MULTI_PART)
				question.setType(QuestionType.IMAGE_HOTSPOT);
		}else if(type.equals(ResponseItemType.MULTIPLE_CHOICE)){
			newItem = new MultipleChoiceResponseItem();
			if (question.getType() != QuestionType.MULTI_PART)
				question.setType(QuestionType.MULTIPLE_CHOICE);
		}else if(type.equals(ResponseItemType.SHORT_ANSWER)){
			newItem = new ShortAnswerResponseItem();
			if (question.getType() != QuestionType.MULTI_PART)
				question.setType(QuestionType.SHORT_ANSWER);
		}else if(type.equals(ResponseItemType.TRUE_FALSE)){
			newItem = new TrueFalseResponseItem();
			if (question.getType() != QuestionType.MULTI_PART)
				question.setType(QuestionType.TRUE_FALSE);
		}
		
		question.addResponseItem(index, newItem.parse(responseItem.getOriginalText()));

	}

}