/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.xml.elements;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import junit.extensions.jfcunit.xml.JFCXMLTestCase;
import junit.extensions.xml.IXMLTestCase;
import junit.extensions.xml.XMLException;
import junit.extensions.xml.elements.AbstractTagHandler;
import junit.framework.Assert;
import org.w3c.dom.Element;

public class EchoTagHandler
extends AbstractTagHandler {
    private static final int YES_OPTION = 0;
    private static final int NO_OPTION = 1;
    private boolean m_result = false;

    public EchoTagHandler(Element element, IXMLTestCase testcase) {
        super(element, testcase);
    }

    public void processElement() throws XMLException {
        this.validateElement();
        String msg = this.getString("message");
        String mode = this.getString("mode");
        if (mode == null) {
            mode = "stdout";
        }
        boolean block = this.getBoolean("block", true);
        if ("dialog".equals(mode)) {
            this.m_result = false;
            if (block) {
                JOptionPane.showMessageDialog(null, msg);
            } else {
                this.showDialog(msg);
            }
            System.err.println("[echo] " + msg);
        } else if ("confirm".equalsIgnoreCase(mode)) {
            System.err.println("[echo] " + msg);
            if (block) {
                this.m_result = JOptionPane.showConfirmDialog(null, msg, "Confirm", 0) == 0;
            } else {
                boolean bl = this.m_result = this.showConfirm(msg) == 0;
            }
            if (!this.m_result) {
                Assert.fail((String)msg);
            }
        } else if ("stderr".equalsIgnoreCase(mode)) {
            System.err.println("[echo] " + msg);
        } else if ("stdout".equalsIgnoreCase(mode)) {
            System.out.println("[echo] " + msg);
        } else {
            throw new XMLException("Invalid mode", null, this.getElement(), this.getXMLTestCase().getPropertyCache());
        }
    }

    public void validateElement() throws XMLException {
        super.validateElement();
        this.checkRequiredAttribute("message");
    }

    int showConfirm(String msg) {
        return this.showDialog(msg, true);
    }

    void showDialog(String msg) {
        this.showDialog(msg, false);
    }

    int showDialog(String msg, boolean confirm) {
        EchoDialog ed = new EchoDialog(msg, confirm);
        ed.setVisible(true);
        IXMLTestCase tc = this.getXMLTestCase();
        while (!ed.getDialogClosed()) {
            if (tc instanceof JFCXMLTestCase) {
                ((JFCXMLTestCase)tc).sleep(1000L);
                continue;
            }
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (InterruptedException ie) {}
        }
        return ed.getResult();
    }

    private class EchoDialog
    extends JDialog
    implements ActionListener {
        private JButton m_no;
        private JButton m_ok;
        private volatile boolean m_dislogClosed = false;
        private int m_result = -1;

        public EchoDialog(String message, boolean confirm) {
            JLabel msg = new JLabel(message);
            this.m_ok = new JButton("OK");
            if (confirm) {
                this.m_ok.setText("Yes");
            }
            this.m_ok.addActionListener(this);
            this.m_no = new JButton("No");
            this.m_no.addActionListener(this);
            this.m_no.setVisible(confirm);
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
            buttonPanel.add(Box.createHorizontalGlue());
            buttonPanel.add(this.m_ok);
            buttonPanel.add(this.m_no);
            buttonPanel.add(Box.createHorizontalGlue());
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 1));
            panel.add(msg);
            panel.add(buttonPanel);
            this.setContentPane(panel);
            this.setModal(false);
            this.pack();
        }

        public boolean getDialogClosed() {
            return this.m_dislogClosed;
        }

        public int getResult() {
            return this.m_result;
        }

        public void actionPerformed(ActionEvent ae) {
            Object source = ae.getSource();
            if (source == this.m_ok) {
                this.m_result = 0;
            } else if (source == this.m_no) {
                this.m_result = 1;
            }
            this.setVisible(false);
            this.dispose();
            this.m_ok = null;
            this.m_no = null;
            this.m_dislogClosed = true;
        }
    }
}

