/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit.eventdata;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Vector;
import junit.extensions.jfcunit.JFCTestCase;
import junit.extensions.jfcunit.eventdata.AbstractEventData;
import junit.extensions.jfcunit.eventdata.AbstractMouseEventData;
import org.w3c.dom.Element;

public class DragEventData
extends AbstractEventData {
    private AbstractMouseEventData m_dest;
    private AbstractMouseEventData m_source;
    private List m_points = new Vector();
    private Point m_origPoint = null;

    public DragEventData(JFCTestCase testCase, AbstractMouseEventData source) {
        this(testCase, source, null, 300L);
    }

    public DragEventData(JFCTestCase testCase, AbstractMouseEventData source, AbstractMouseEventData dest) {
        this(testCase, source, dest, 300L);
    }

    public DragEventData(JFCTestCase testCase, AbstractMouseEventData source, AbstractMouseEventData dest, long delay) {
        this.setTestCase(testCase);
        this.setSource(source);
        this.setDest(dest);
        this.setSleepTime(delay);
        if (this.getSource() != null && this.getSource().isValid()) {
            this.setValid(true);
        }
    }

    public final Component getComponent() {
        return null;
    }

    public final int getDefaultModifiers() {
        return this.m_source.getDefaultModifiers();
    }

    public final void setDest(AbstractMouseEventData dest) {
        this.m_dest = dest;
    }

    public final AbstractMouseEventData getDest() {
        return this.m_dest;
    }

    public final String getModifierText() {
        return this.m_source.getModifierText();
    }

    public final void setPoints(Point[] points) {
        this.m_points.clear();
        for (int i = 0; i < points.length; ++i) {
            this.m_points.add(points[i]);
        }
    }

    public final Point[] getPoints() {
        return this.m_points.toArray(new Point[0]);
    }

    public final void setSource(AbstractMouseEventData source) {
        this.m_source = source;
        if (this.m_source != null && this.m_source.getComponent() != null && this.m_source.getComponent().isVisible()) {
            this.m_origPoint = this.m_source.getLocationOnScreen();
        }
    }

    public final AbstractMouseEventData getSource() {
        return this.m_source;
    }

    public final void addPoint(Point p) {
        this.m_points.add(p);
    }

    public final boolean prepareComponent() {
        boolean results = true;
        boolean resultd = true;
        if (this.m_source != null) {
            results = this.m_source.prepareComponent();
            this.m_points.add(0, this.m_source.getLocationOnScreen());
        }
        Point compLocation = this.m_source.getComponent().getLocationOnScreen();
        if (this.m_points.size() > 1) {
            for (int i = 1; i < this.m_points.size(); ++i) {
                Point p = (Point)this.m_points.get(i);
                p.translate(compLocation.x, compLocation.y);
            }
        }
        if (this.m_dest != null) {
            resultd = this.m_dest.prepareComponent();
            this.m_points.add(this.m_dest.getLocationOnScreen());
        }
        return results & resultd;
    }

    public boolean canConsume(AWTEvent ae) {
        if (!(ae instanceof MouseEvent)) {
            return false;
        }
        MouseEvent me = (MouseEvent)ae;
        if (me.getID() == 506 || me.getID() == 505 || me.getID() == 504) {
            return true;
        }
        if (this.isValid()) {
            return this.getSource().canConsume(ae);
        }
        return false;
    }

    public boolean consume(AWTEvent ae) {
        if (!(ae instanceof MouseEvent)) {
            return false;
        }
        MouseEvent me = (MouseEvent)ae;
        if (me.getID() == 504 || me.getID() == 505) {
            return true;
        }
        if (me.getID() != 506) {
            return this.getSource().consume(ae);
        }
        Point p = this.convertToSource(me.getComponent(), me.getPoint());
        this.addPoint(p);
        return true;
    }

    public boolean equals(Object o) {
        if (!(o instanceof DragEventData)) {
            return false;
        }
        DragEventData ded = (DragEventData)o;
        if (this.m_source == null ? ded.getSource() != null : !this.m_source.equals(ded.getSource())) {
            return false;
        }
        return !(this.m_dest == null ? ded.getDest() != null : !this.m_dest.equals(ded.getDest()));
    }

    public int hashCode() {
        int hc = super.hashCode();
        if (this.m_source != null) {
            hc += this.m_source.hashCode();
        }
        if (this.m_dest != null) {
            hc += this.m_dest.hashCode();
        }
        return hc;
    }

    public void populate(Element e) {
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(1000);
        buf.append("DragEventData:");
        if (!this.isValid()) {
            buf.append(" invalid");
            return buf.toString();
        }
        buf.append("(Source:" + this.getSource().toString() + ")");
        buf.append("Points:");
        for (int i = 0; i < this.m_points.size(); ++i) {
            if (i != 0) {
                buf.append(",");
            }
            buf.append(this.m_points.get(i));
        }
        return buf.toString();
    }

    private Point convertToSource(Component comp, Point p) {
        Point screen = comp.getLocationOnScreen();
        screen.translate(p.x, p.y);
        if (this.m_origPoint == null) {
            return p;
        }
        int dx = screen.x - this.m_origPoint.x;
        int dy = screen.y - this.m_origPoint.y;
        Point delta = new Point(p);
        delta.translate(dx, dy);
        return delta;
    }
}

