/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.WindowEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import junit.extensions.jfcunit.ExitException;

public final class WindowMonitor
implements AWTEventListener {
    private static WindowMonitor s_singleton = null;
    private static DispatchThread s_dt = null;
    private static volatile boolean s_running = true;
    private static WindowEventItem s_windowEventQueue = null;
    private static final Object QLOCK = new Object();
    private static final ArrayList WINDOWS = new ArrayList();

    private WindowMonitor() {
        if (s_dt == null) {
            Frame[] frames = Frame.getFrames();
            for (int i = 0; i < frames.length; ++i) {
                WindowMonitor.populateWindows(frames[i]);
            }
            s_dt = new DispatchThread("WindowMonitor-DispatchThread");
            s_dt.setDaemon(true);
            s_dt.start();
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 64L);
        }
    }

    public static Window[] getWindows() {
        ArrayList<Window> v = new ArrayList<Window>();
        ArrayList<WeakReference> toRemove = new ArrayList<WeakReference>();
        for (int i = 0; i < WINDOWS.size(); ++i) {
            WeakReference r = (WeakReference)WINDOWS.get(i);
            Window w = (Window)r.get();
            if (w == null) {
                toRemove.add(r);
                continue;
            }
            v.add(w);
        }
        WINDOWS.removeAll(toRemove);
        return v.toArray(new Window[0]);
    }

    public static void start() {
        WindowMonitor.getSingleton();
    }

    public static void stop() {
        WindowMonitor.getSingleton().stopInternal();
    }

    public void eventDispatched(AWTEvent theEvent) {
        WindowMonitor.processEvent(theEvent);
    }

    private static WindowMonitor getSingleton() {
        if (s_singleton == null) {
            s_singleton = new WindowMonitor();
        }
        return s_singleton;
    }

    private static void flushAWT() {
        Toolkit.getDefaultToolkit().getSystemEventQueue();
        if (EventQueue.isDispatchThread()) {
            return;
        }
        try {
            Toolkit.getDefaultToolkit().getSystemEventQueue();
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void populateWindows(Window w) {
        WINDOWS.add(new WeakReference<Window>(w));
        Window[] windows = w.getOwnedWindows();
        for (int i = 0; i < windows.length; ++i) {
            WindowMonitor.populateWindows(windows[i]);
        }
    }

    private static void processEvent(AWTEvent theEvent) {
        switch (theEvent.getID()) {
            case 200: 
            case 201: 
            case 205: 
            case 206: {
                WindowMonitor.queueWindowEvent((WindowEvent)theEvent);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void queueWindowEvent(WindowEvent we) {
        Object object = QLOCK;
        synchronized (object) {
            WindowEventItem qi = new WindowEventItem(we);
            if (s_windowEventQueue == null) {
                s_windowEventQueue = qi;
            } else {
                WindowEventItem q = s_windowEventQueue;
                while (q.getNext() != null) {
                    q = q.getNext();
                }
                q.setNext(qi);
            }
            QLOCK.notifyAll();
        }
    }

    private void stopInternal() {
        s_running = false;
    }

    private boolean containsKey(Window key) {
        ArrayList<WeakReference> toRemove = new ArrayList<WeakReference>();
        boolean result = false;
        for (int i = 0; i < WINDOWS.size() && !result; ++i) {
            WeakReference r = (WeakReference)WINDOWS.get(i);
            Window w = (Window)r.get();
            if (w == null) {
                toRemove.add(r);
                continue;
            }
            if (w != key) continue;
            result = true;
        }
        WINDOWS.removeAll(toRemove);
        return result;
    }

    private Object remove(Window key) {
        ArrayList<WeakReference> toRemove = new ArrayList<WeakReference>();
        Window result = null;
        for (int i = 0; i < WINDOWS.size() && result == null; ++i) {
            WeakReference r = (WeakReference)WINDOWS.get(i);
            Window w = (Window)r.get();
            if (w == null) {
                toRemove.add(r);
                continue;
            }
            if (w != key) continue;
            toRemove.add(r);
            result = w;
        }
        WINDOWS.removeAll(toRemove);
        return result;
    }

    private static class WindowEventItem {
        private WindowEvent m_event;
        private WindowEventItem m_next;

        WindowEventItem(WindowEvent evt) {
            this.m_event = evt;
            this.m_next = null;
        }

        public WindowEvent getEvent() {
            return this.m_event;
        }

        public void setNext(WindowEventItem n) {
            this.m_next = n;
        }

        public WindowEventItem getNext() {
            return this.m_next;
        }
    }

    private class DispatchThread
    extends Thread {
        public DispatchThread(String name) {
            super(name);
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            WindowEvent we = null;
            while (s_running) {
                Object object;
                while (s_windowEventQueue == null) {
                    object = QLOCK;
                    synchronized (object) {
                        try {
                            QLOCK.wait(500L);
                        }
                        catch (ExitException exe) {
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                }
                object = QLOCK;
                synchronized (object) {
                    we = s_windowEventQueue.getEvent();
                    s_windowEventQueue = s_windowEventQueue.getNext();
                    switch (we.getID()) {
                        case 200: 
                        case 205: 
                        case 206: {
                            if (WindowMonitor.this.containsKey(we.getWindow())) break;
                            WINDOWS.add(new WeakReference<Window>(we.getWindow()));
                            break;
                        }
                        case 201: {
                            WindowMonitor.this.remove(we.getWindow());
                            break;
                        }
                    }
                    try {
                        QLOCK.notifyAll();
                    }
                    catch (ExitException exitException) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

