/*
 * Decompiled with CFR 0.152.
 */
package tool.pdf;

import com.pt.io.FileList;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import multivalent.ParseException;
import multivalent.std.adaptor.pdf.COS;
import multivalent.std.adaptor.pdf.Dict;
import multivalent.std.adaptor.pdf.IRef;
import multivalent.std.adaptor.pdf.PDFReader;
import multivalent.std.adaptor.pdf.SecurityHandler;
import multivalent.std.adaptor.pdf.SecurityHandlerStandard;
import phelps.awt.geom.Rectangles2D;
import phelps.io.PrintStreams;

public class Validate {
    static final boolean DEBUG = false;
    public static final String VERSION = "1.3 of $Date: 2004/03/13 03:52:51 $";
    public static final String COPYRIGHT = "Copyright (c) 2002 - 2005  Thomas A. Phelps.  All rights reserved.";
    private static final String USAGE = "java tool.pdf.Validate [<options>] <PDF-file...>\n\t[-fast | -full | -obj]\n\t[-password <password>] [-verbose] [-quiet]";
    public static final int LEVEL_FAST = 0;
    public static final int LEVEL_FULL = 1;
    public static final int LEVEL_OBJECTS = 2;
    public static final int LEVEL_DEVEL = 10;
    public static final int LEVEL_DEVEL_WARNING = 11;
    public static final int LEVEL_DEVEL_CONTENT = 12;
    private static final String[] ATTRS_PAGES;
    private static final String[] ATTRS_PAGE;
    private static final String[] ATTRS_IMAGE;
    static final int OVERLAP_FUZZ = 3;
    private List<String> errs_ = new ArrayList<String>(10);
    private boolean frepairok_;
    private int level_;
    private String name1_;
    private boolean fverbose_;
    private boolean fquiet_;
    private boolean fmonitor_;
    private PrintStream out_;
    private String password_;
    private boolean fencryption_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Validate() {
        this.defaults();
    }

    public void defaults() {
        this.password_ = null;
        this.frepairok_ = true;
        this.level_ = 10;
        this.fencryption_ = false;
        this.fmonitor_ = false;
        this.fquiet_ = false;
        this.fverbose_ = false;
        this.out_ = PrintStreams.DEVNULL;
    }

    public void setLevel(int n) {
        if (!($assertionsDisabled || 0 <= n && n <= 12)) {
            throw new AssertionError();
        }
        this.level_ = n;
    }

    public void setRepair(boolean bl) {
        this.frepairok_ = bl;
    }

    public boolean validate(File file) throws IOException {
        if (this.fverbose_) {
            System.out.println(file);
        }
        if (!($assertionsDisabled || file != null && file.exists())) {
            throw new AssertionError();
        }
        this.errs_.clear();
        PDFReader pDFReader = null;
        try {
            this.name1_ = file.getPath();
            pDFReader = new PDFReader(file);
        }
        catch (ParseException parseException) {
            this.err(-1, parseException.toString());
            return false;
        }
        catch (IOException iOException) {
            System.err.println("Can't open " + file);
            throw iOException;
        }
        return this.validate(pDFReader);
    }

    public boolean validate(PDFReader pDFReader) throws IOException {
        pDFReader.setExact(true);
        pDFReader.setPassword(this.password_);
        if (!pDFReader.isAuthorized()) {
            this.err(-1, "invalid password " + pDFReader.getURI());
            return false;
        }
        if (!this.frepairok_ && pDFReader.isRepaired()) {
            return false;
        }
        if (this.level_ >= 1 && this.errs_.isEmpty()) {
            this.validateFull(pDFReader);
        }
        if (!this.frepairok_ && pDFReader.isRepaired()) {
            return false;
        }
        int n = pDFReader.getPageCnt();
        if (this.level_ >= 2 && this.errs_.isEmpty()) {
            for (int i = 1; i <= n; ++i) {
                if (this.fmonitor_) {
                    this.out_.print(" " + i);
                }
                Dict dict = pDFReader.getPage(i);
                if (this.level_ < 2 || !this.errs_.isEmpty()) continue;
                this.validateAnnots(dict, i, pDFReader);
            }
        }
        if (this.fmonitor_ && n > 0) {
            this.out_.println();
        }
        if (this.level_ >= 10 && this.errs_.isEmpty()) {
            this.validateDev(pDFReader);
        }
        String string = null;
        if (this.fencryption_) {
            string = this.validateEncryption(pDFReader);
        }
        if (string != null) {
            System.out.println("encryption: " + string);
        }
        pDFReader.close();
        if (this.errs_.isEmpty() && pDFReader.isRepaired()) {
            this.err(-1, "invalid but repairable (with tool.pdf.Repair)");
        }
        return this.errs_.isEmpty();
    }

    public boolean validateFull(PDFReader pDFReader) throws IOException {
        boolean bl = true;
        Object object = null;
        pDFReader.fault();
        int n = pDFReader.getObjCnt();
        for (int i = 1; i < n; ++i) {
            try {
                object = pDFReader.getObject(i);
                if (COS.CLASS_DICTIONARY != object.getClass() || ((Dict)object).get("DATA") == null) continue;
                byte[] byArray = pDFReader.getStreamData(new IRef(i, pDFReader.getObjGen(i)), false, false);
                continue;
            }
            catch (Exception exception) {
                this.err(i, exception.toString());
                System.out.println("#" + i + ": " + object);
                bl = false;
                break;
            }
        }
        return bl;
    }

    public boolean validateAnnots(Dict dict, int n, PDFReader pDFReader) throws IOException {
        int n2 = this.errs_.size();
        int n3 = pDFReader.getObjCnt();
        int n4 = pDFReader.getPageCnt();
        Object object = dict.get("Annots");
        if (object == null) {
            return true;
        }
        Object[] objectArray = (Object[])pDFReader.getObject(object);
        if (COS.OBJECT_NULL == objectArray) {
            return true;
        }
        int n5 = COS.CLASS_IREF == object.getClass() ? ((IRef)object).id : -1;
        ArrayList<Rectangle> arrayList = new ArrayList<Rectangle>(10);
        for (int i = objectArray.length - 1; i >= 0; --i) {
            Iterator iterator;
            object = objectArray[i];
            int n6 = COS.CLASS_IREF == object.getClass() ? ((IRef)object).id : n5;
            if (COS.CLASS_DICTIONARY != (object = pDFReader.getObject(object)).getClass()) continue;
            Dict dict2 = (Dict)object;
            Object object2 = pDFReader.getObject(dict2.get("Type"));
            Object object3 = pDFReader.getObject(dict2.get("Subtype"));
            if (object2 != null && !"Annot".equals(object2)) {
                this.err(n6, "no /Type /Annot");
                continue;
            }
            if ("Link".equals(object3)) {
                iterator = dict2.get("Dest");
                Object object4 = dict2.get("A");
                if (iterator == null && object4 == null) {
                    this.err(n6, "link annotation but no destination (no /Dest or /A)");
                } else if (iterator != null && object4 != null) {
                    this.err(n6, "link annotation has both /Dest and /A");
                } else if (iterator != null) {
                    this.checkDest(iterator, n, n6, pDFReader);
                }
                Rectangle rectangle = COS.array2Rectangle((Object[])pDFReader.getObject(dict2.get("Rect")), null);
                int n7 = rectangle.width * rectangle.height;
                int n8 = arrayList.size();
                for (int j = 0; j < n8; ++j) {
                    Rectangle rectangle2 = (Rectangle)arrayList.get(j);
                    Rectangle rectangle3 = rectangle.intersection(rectangle2);
                    if (rectangle3.width <= 0 || rectangle3.height <= 0) continue;
                    if (rectangle3.width * rectangle3.height == n7) {
                        this.err(-1, "page " + n + ": link rectangle " + Rectangles2D.pretty(rectangle2) + " blocks " + Rectangles2D.pretty(rectangle));
                        break;
                    }
                    if (rectangle3.width <= 3 || rectangle3.height <= 3) continue;
                    this.err(-1, "page " + n + ": link rectangle " + Rectangles2D.pretty(rectangle2) + " partially overlaps " + Rectangles2D.pretty(rectangle));
                    break;
                }
                arrayList.add(rectangle);
            }
            if ((object = dict2.get("A")) != null && !"Movie".equals(object3)) {
                this.validateAction(object, n, n6, pDFReader);
            }
            if ((object = pDFReader.getObject(dict2.get("AA"))) == null || COS.CLASS_DICTIONARY != object.getClass()) continue;
            iterator = ((Dict)object).values().iterator();
            while (iterator.hasNext()) {
                this.validateAction(iterator.next(), n, n6, pDFReader);
            }
        }
        return n2 == this.errs_.size();
    }

    private void checkDest(Object object, int n, int n2, PDFReader pDFReader) throws IOException {
        Object object2;
        if (object == null) {
            return;
        }
        String string = null;
        Object object3 = object;
        Class<?> clazz = (object = pDFReader.getObject(object)).getClass();
        if (COS.CLASS_ARRAY == clazz) {
            object2 = (Object[])object;
            Object object4 = pDFReader.getObject(object2[0]);
            if (COS.CLASS_DICTIONARY == object4.getClass()) {
                Dict dict = (Dict)object4;
                if (!"Page".equals(pDFReader.getObject(dict.get("Type")))) {
                    string = "doesn't point to page";
                }
            } else {
                string = "points to bad page: " + object4;
            }
        } else if (COS.CLASS_NAME == clazz || COS.CLASS_STRING == clazz) {
            if (COS.CLASS_NAME == clazz) {
                object2 = pDFReader.getObject(pDFReader.getCatalog().get("Dests"));
            } else {
                if (!$assertionsDisabled && COS.CLASS_STRING != clazz) {
                    throw new AssertionError();
                }
                object2 = pDFReader.getObject(pDFReader.getCatalog().get("Names"));
                if (object2 == null || COS.OBJECT_NULL == object2 || COS.CLASS_DICTIONARY != object2.getClass()) {
                    string = "named destination but no /Names dictionary";
                } else {
                    object2 = pDFReader.getObject(((Dict)object2).get("Dests"));
                }
            }
            if (string == null) {
                if (object2 == null || COS.OBJECT_NULL == object2) {
                    string = "named destination but no /Dests dictionary";
                } else if (COS.CLASS_DICTIONARY == object2.getClass()) {
                    Dict dict = (Dict)object2;
                    Object object5 = object2 = COS.CLASS_NAME == clazz ? pDFReader.getObject(dict.get(object)) : pDFReader.findNameTree(dict, (StringBuffer)object);
                    if (object2 == null) {
                        string = "named destination '" + object + "' does not exist";
                    } else if (COS.OBJECT_NULL == object) {
                        string = "points to null";
                    } else {
                        Object object6 = pDFReader.getObject(object2);
                        if (COS.CLASS_DICTIONARY == object6.getClass()) {
                            object6 = ((Dict)object6).get("D");
                        }
                        this.checkDest(object6, n, n2, pDFReader);
                    }
                }
            }
        } else {
            string = COS.OBJECT_NULL == object ? "points to null" : "has invalid type (should be array, name, or string)";
        }
        if (string != null) {
            int n3 = COS.CLASS_IREF == object3.getClass() ? ((IRef)object3).id : -1;
            this.err(n3, "on page " + n + " in object " + n2 + ": " + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void validateAction(Object var1_1, int var2_2, int var3_3, PDFReader var4_4) throws IOException {
        if (var1_1 == null) {
            return;
        }
        if (COS.CLASS_IREF == var1_1.getClass()) {
            var3_3 = ((IRef)var1_1).id;
            var1_1 = var4_4.getObject(var1_1);
        }
        if (COS.CLASS_ARRAY == var1_1.getClass()) {
            var5_5 = (Object[])var1_1;
            var6_6 = ((Object[])var5_5).length;
            for (var7_8 = 0; var7_8 < var6_6; ++var7_8) {
                var8_10 = var5_5[var7_8];
                this.validateAction(var8_10, var2_2, var3_3, var4_4);
            }
        }
        if (COS.CLASS_DICTIONARY != var1_1.getClass()) {
            return;
        }
        var5_5 = (Dict)var1_1;
        var6_7 = null;
        var8_10 = (String)var4_4.getObject(var5_5.get("S"));
        if ("GoTo".equals(var8_10)) {
            this.checkDest(var5_5.get("D"), var2_2, var3_3, var4_4);
        } else if ("GoToR".equals(var8_10)) {
            var9_11 = var4_4.getObject(var5_5.get("F"));
            var10_13 = var4_4.getObject(var5_5.get("D"));
            if (var9_11 == null || COS.OBJECT_NULL == var9_11) {
                this.err(var3_3, "no destination file (/F)");
            } else if (COS.CLASS_STRING != var9_11.getClass()) {
                if (COS.CLASS_STRING != var9_11.getClass()) {
                    this.err(var3_3, "/F not string or dictionary");
                } else {
                    var11_14 = (Dict)var9_11;
                    var7_9 = var4_4.getObject(var11_14.get("F"));
                    var12_15 = new File(new File(var4_4.getURI()), var7_9.toString());
                    if (!var12_15.exists()) {
                        this.err(var3_3, "destination file not found: " + var7_9);
                    } else if (var10_13 == null || COS.OBJECT_NULL == var10_13) {
                        this.err(var3_3, "no destination within file " + var9_11);
                    } else {
                        var13_16 = null;
                        try {
                            var13_16 = new PDFReader(var12_15);
                            if (COS.CLASS_ARRAY == var10_13.getClass()) {
                                var7_9 = var4_4.getObject(((Object[])var10_13)[0]);
                                if (!(var7_9 instanceof Number) || (var14_17 = ((Number)var7_9).intValue()) >= 1 && var14_17 <= var13_16.getPageCnt()) ** GOTO lbl62
                                this.err(var3_3, "points to page " + var14_17 + " in " + var9_11 + ", but only " + var13_16.getPageCnt() + " pages");
                            }
                            this.checkDest(var10_13, var2_2, var3_3, var13_16);
                        }
                        catch (Exception var14_18) {
                        }
                        finally {
                            if (var13_16 != null) {
                                var13_16.close();
                            }
                        }
                    }
                }
            }
        } else if ("Launch".equals(var8_10)) {
            var9_12 = var4_4.getObject(var5_5.get("F"));
        } else if ("URI".equals(var8_10)) {
            // empty if block
        }
lbl62:
        // 14 sources

        this.validateAction(var5_5.get("Next"), var2_2, var3_3, var4_4);
    }

    public void validateDev(PDFReader pDFReader) throws IOException {
        Object object;
        Object object2;
        int n;
        Dict dict;
        Object object3;
        Dict dict2;
        int n2 = pDFReader.getObjCnt();
        int n3 = pDFReader.getPageCnt();
        if (n3 == 0) {
            this.warn(-1, "No pages");
        }
        if ((dict2 = pDFReader.getTrailer()).get("Root") == null) {
            this.err(-1, "No /Root in trailer");
        }
        if ((object3 = dict2.get("Size")) == null) {
            this.err(-1, "No /Size in trailer");
        } else if (COS.CLASS_INTEGER != object3.getClass()) {
            this.err(-1, "/Size in trailer not direct integer");
        } else {
            int n4 = ((Number)object3).intValue();
            if (n4 != n2) {
                this.err(-1, "Wrong /Size in trailer: " + n4 + " should be " + n2);
            }
        }
        Dict dict3 = pDFReader.getCatalog();
        if (dict3.get("Pages") == null) {
            this.warn(-1, "No /Pages in catalog");
        }
        if ((dict = pDFReader.getInfo()) == null) {
            this.warn(-1, "No /Info with metadata in trailer");
        }
        for (n = 0; n < n3; ++n) {
            object2 = pDFReader.getPageRef(n + 1);
            object = pDFReader.getPage(n + 1);
            this.requiredAttrs(((IRef)object2).id, (Dict)object, ATTRS_PAGE);
        }
        for (n = 0; n < n2; ++n) {
            object3 = pDFReader.getObject(n);
            if (COS.CLASS_DICTIONARY != object3.getClass()) continue;
            object2 = (Dict)object3;
            object = (String)((Dict)object2).get("Type");
            String string = (String)((Dict)object2).get("Subtype");
            if ("Pages".equals(object)) {
                this.requiredAttrs(n, (Dict)object2, ATTRS_PAGES);
                continue;
            }
            if ("Page".equals(object)) {
                if (((Dict)object2).get("Contents") != null) continue;
                this.warn(n, "/Page without /Contents");
                continue;
            }
            if (("XObject".equals(object) || null == object) && "Image".equals(string)) {
                this.requiredAttrs(n, (Dict)object2, ATTRS_IMAGE);
                continue;
            }
            if (("XObject".equals(object) || null == object) && !"Image".equals(string)) continue;
        }
    }

    private void requiredAttrs(int n, Dict dict, String[] stringArray) {
        boolean bl = true;
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String string = stringArray[i];
            if (dict.get(string) != null) continue;
            this.err(n, "missing attr '" + string + "'");
        }
    }

    public String validateEncryption(PDFReader pDFReader) throws IOException {
        Object object;
        Dict dict = (Dict)pDFReader.getObject(pDFReader.getTrailer().get("Encrypt"));
        if (dict == null) {
            return "no encryption";
        }
        SecurityHandler securityHandler = pDFReader.getEncrypt().getSecurityHandler();
        if (securityHandler instanceof SecurityHandlerStandard) {
            int n;
            Object object2 = dict.get("Length");
            int n2 = n = object2 != null ? ((Number)object2).intValue() : 40;
        }
        if (securityHandler.authOwner(null)) {
            return "null owner password -- easily decrypted";
        }
        int n = 32;
        char c = '~';
        boolean bl = securityHandler.authUser(null);
        for (int i = 1; i <= 4; ++i) {
            if (this.fverbose_) {
                this.out_.print("length " + i + " ");
            }
            object = new char[i + 1];
            if (i > 3) {
                n = 97;
                c = 'z';
            }
            for (int j = 1; j <= i; ++j) {
                object[j] = n;
            }
            block2: while (object[0] == '\u0000') {
                String string = new String((char[])object, 1, i);
                if (!bl && securityHandler.authUser(string)) {
                    return "easily guessed user password: '" + string + "'";
                }
                if (securityHandler.authOwner(string)) {
                    return "easily guessed owner password: '" + string + "'";
                }
                for (int j = i; j >= 0; --j) {
                    int n3 = j;
                    object[n3] = (char)(object[n3] + '\u0001');
                    if (j == 1 && this.fverbose_) {
                        System.out.print(object[j]);
                    }
                    if (object[j] <= c) continue block2;
                    object[j] = n;
                }
            }
            if (!this.fverbose_) continue;
            this.out_.println();
        }
        ArrayList<String> arrayList = new ArrayList<String>(1000);
        object = this.getClass().getResourceAsStream("edict.txt");
        if (object != null) {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object));
            while ((string = bufferedReader.readLine()) != null) {
                if (string.length() <= 3) continue;
                arrayList.add(string);
            }
            bufferedReader.close();
        }
        if ((object = (Object)this.getClass().getResourceAsStream("/sys/words.txt")) != null) {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object));
            while ((string = bufferedReader.readLine()) != null) {
                if (string.length() <= 3) continue;
                arrayList.add(string);
            }
            bufferedReader.close();
        }
        if (this.fverbose_) {
            this.out_.println(arrayList.size() + "-word list");
        }
        int n4 = arrayList.size();
        for (int i = 0; i < n4; ++i) {
            String string;
            String string2 = string = (String)arrayList.get(i);
            if (i % 1000 == 0) {
                this.out_.print(" " + string2);
            }
            if (!bl && securityHandler.authUser(string2)) {
                return "easily guessed user password: '" + string2 + "'";
            }
            if (securityHandler.authOwner(string2)) {
                return "easily guessed owner password: '" + string2 + "'";
            }
            string2 = string.toLowerCase();
            if (!string2.equals(string)) {
                if (!bl && securityHandler.authUser(string2)) {
                    return "easily guessed user password: '" + string2 + "'";
                }
                if (securityHandler.authOwner(string2)) {
                    return "easily guessed owner password: '" + string2 + "'";
                }
            }
            string2 = new StringBuffer(string).reverse().toString();
            if (!bl && securityHandler.authUser(string2)) {
                return "easily guessed user password: '" + string2 + "'";
            }
            if (!securityHandler.authOwner(string2)) continue;
            return "easily guessed owner password: '" + string2 + "'";
        }
        return null;
    }

    private void err(int n, String string) {
        if (this.name1_ != null) {
            this.out_.println("File: " + this.name1_);
            this.name1_ = null;
        }
        String string2 = "ERROR";
        if (n >= 0) {
            string2 = string2 + ".  object #" + n;
        }
        string2 = string2 + ": " + string;
        this.errs_.add(string2);
        this.out_.println(string2);
    }

    private void warn(int n, String string) {
        if (this.level_ < 11) {
            return;
        }
        if (this.name1_ != null) {
            this.out_.println("File: " + this.name1_);
            this.name1_ = null;
        }
        this.out_.print("WARNING.  ");
        if (n >= 0) {
            this.out_.print(" object #" + n);
        }
        this.out_.println(": " + string);
    }

    private int commandLine(String[] stringArray) {
        String string;
        int n;
        this.level_ = 1;
        this.out_ = System.out;
        int n2 = stringArray.length;
        for (n = 0; n < n2 && (string = stringArray[n]).startsWith("-"); ++n) {
            if ((string = string.toLowerCase()).startsWith("--")) {
                string = string.substring(1);
            }
            if (string.equals("-fast") || string.equals("-quick")) {
                this.level_ = 0;
                continue;
            }
            if (string.equals("-full")) {
                this.level_ = 1;
                continue;
            }
            if (string.startsWith("-dev")) {
                this.level_ = 10;
                continue;
            }
            if (string.startsWith("-obj") || string.startsWith("-link")) {
                this.level_ = 2;
                continue;
            }
            if (string.startsWith("-enc")) {
                this.fencryption_ = true;
                continue;
            }
            if (string.startsWith("-rep")) {
                this.setRepair(true);
                continue;
            }
            if (string.startsWith("-pass")) {
                this.password_ = stringArray[++n];
                continue;
            }
            if (string.startsWith("-verb")) {
                this.fverbose_ = true;
                continue;
            }
            if (string.startsWith("-mon")) {
                this.fverbose_ = true;
                this.fmonitor_ = true;
                this.fquiet_ = false;
                continue;
            }
            if (string.startsWith("-v")) {
                System.out.println(VERSION);
                System.exit(0);
                continue;
            }
            if (string.startsWith("-h")) {
                System.out.println(USAGE);
                System.exit(0);
                continue;
            }
            System.err.println("Unknown option: " + string);
            System.err.println(USAGE);
            System.exit(1);
        }
        if (10 == this.level_ && this.fverbose_) {
            this.level_ = 11;
        }
        if (n == n2) {
            System.err.println(USAGE);
            System.exit(0);
        }
        return n;
    }

    public static void main(String[] stringArray) {
        Validate validate = new Validate();
        int n = validate.commandLine(stringArray);
        Iterator<File> iterator = new FileList(stringArray, n, COS.FILTER).iterator();
        while (iterator.hasNext()) {
            File file = iterator.next();
            if (System.getSecurityManager() != null) continue;
            try {
                validate.validate(file);
            }
            catch (Exception exception) {
                System.err.println(file + ": " + exception);
            }
        }
        System.exit(0);
    }

    static {
        $assertionsDisabled = !Validate.class.desiredAssertionStatus();
        ATTRS_PAGES = new String[]{"Type", "Count", "Kids"};
        ATTRS_PAGE = new String[]{"Type", "Parent", "Resources", "MediaBox"};
        ATTRS_IMAGE = new String[]{"Width", "Height"};
    }
}

