/*
 * Decompiled with CFR 0.152.
 */
package tool.pdf;

import com.pt.io.FileList;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import multivalent.ParseException;
import multivalent.std.adaptor.pdf.COS;
import multivalent.std.adaptor.pdf.Dict;
import multivalent.std.adaptor.pdf.IRef;
import multivalent.std.adaptor.pdf.PDFReader;
import multivalent.std.adaptor.pdf.PDFWriter;
import phelps.io.Files;
import phelps.io.PrintStreams;
import phelps.lang.Integers;
import phelps.util.Arrayss;
import phelps.util.Version;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Merge {
    private static final boolean DEBUG = false;
    public static final String VERSION = "1.2 of $Date: 2005/01/10 14:54:53 $";
    public static final String COPYRIGHT = "Copyright (c) 2002 - 2005  Thomas A. Phelps.  All rights reserved.";
    private static final String USAGE = "java tool.pdf.Merge [<options>] <PDF-file1> <PDF-file2>...\n\t[-append] [-samedoc]\n\t[-password <password>] [-verbose] [-quiet]";
    private static final String[] NAME_TREES;
    private boolean fappend_;
    private boolean fsamedoc_;
    private String password_;
    private boolean fverbose_;
    private boolean fquiet_;
    private boolean fmonitor_;
    private PrintStream out_;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$tool$pdf$Merge;

    public Merge() {
        this.defaults();
    }

    public void defaults() {
        this.fappend_ = false;
        this.fsamedoc_ = false;
        this.password_ = null;
        this.fmonitor_ = false;
        this.fquiet_ = false;
        this.fverbose_ = false;
        this.out_ = PrintStreams.DEVNULL;
    }

    public void setOut(PrintStream printStream) {
        this.out_ = printStream != null ? printStream : PrintStreams.DEVNULL;
    }

    public void merge(FileList fileList, File file) throws IOException, ParseException {
        if (!$assertionsDisabled && fileList == null) {
            throw new AssertionError();
        }
        Iterator<File> iterator = fileList.iterator();
        if (!iterator.hasNext()) {
            throw new IOException("need at least one file");
        }
        File file2 = iterator.next();
        if (file == null) {
            String string = file2.getPath();
            String string2 = new StringBuffer().append(string.toLowerCase().endsWith(".pdf") ? string.substring(0, string.length() - ".pdf".length()) : string).append("-m.pdf").toString();
            file = new File(string2);
        }
        file.delete();
        if (!this.fquiet_) {
            this.out_.println(new StringBuffer().append("copy ").append(file2).toString());
        }
        Files.copy(file2, file);
        this.append(file, iterator);
    }

    public void merge(File file, FileList fileList) throws IOException, ParseException {
        if (!($assertionsDisabled || file != null && fileList != null)) {
            throw new AssertionError();
        }
        if (!this.fquiet_) {
            this.out_.print(new StringBuffer().append("append to ").append(file).toString());
        }
        this.append(file, fileList.iterator());
    }

    private void append(File file, Iterator<File> iterator) throws IOException, ParseException {
        int n;
        int n2;
        int n3;
        int n4;
        Object n12;
        Serializable serializable;
        Object object2;
        Version version;
        int n5;
        if (!iterator.hasNext()) {
            return;
        }
        PDFReader pDFReader = new PDFReader(file);
        pDFReader.setPassword(this.password_);
        pDFReader.setExact(true);
        int n6 = n5 = pDFReader.getObjCnt();
        int n7 = n5;
        int n8 = pDFReader.getPageCnt();
        Version version2 = version = pDFReader.getVersion();
        long[] lArray = new long[n6 + 3];
        long l = pDFReader.getStartXRef();
        Dict dict = new Dict();
        Dict dict2 = pDFReader.getTrailer();
        String[] stringArray2 = new String[]{"Encrypt", "ID", "Compress", "Root"};
        for (String stringArray3 : stringArray2) {
            object2 = dict2.get(stringArray3);
            if (object2 == null) continue;
            dict.put(stringArray3, object2);
        }
        Dict dict3 = new Dict();
        dict3.put("Type", "Catalog");
        IRef iRef = new IRef(n6++, 0);
        Dict dict4 = pDFReader.getCatalog();
        String[] stringArray = new String[]{"Dests", "PageMode"};
        for (String n9 : stringArray) {
            object2 = dict4.get(n9);
            if (object2 == null) continue;
            dict3.put(n9, pDFReader.getObject(object2));
        }
        ArrayList arrayList = new ArrayList(10);
        List[] listArray = new ArrayList[NAME_TREES.length];
        int dict6 = listArray.length;
        for (int dict5 = 0; dict5 < dict6; ++dict5) {
            listArray[dict5] = new ArrayList(10);
        }
        Dict dict5 = (Dict)dict2.get("Compress");
        if (dict5 != null && dict5.get("Root") != null) {
            dict5.put("Root", iRef);
        } else {
            dict.put("Root", iRef);
        }
        Dict dict7 = new Dict();
        IRef iRef2 = new IRef(n6++, 0);
        dict7.put("Producer", new StringBuffer("Multivalent Merge"));
        StringBuffer stringBuffer = new StringBuffer(200);
        dict7.put("Merge", stringBuffer);
        stringBuffer.append(file.getName());
        Dict dict8 = pDFReader.getInfo();
        StringBuffer stringBuffer2 = COS.createDate(System.currentTimeMillis());
        if (this.fappend_ && dict8 != null && (object2 = dict8.get("CreationDate")) != null) {
            dict7.put("CreationDate", object2);
            dict7.put("ModDate", stringBuffer2);
        } else {
            dict7.put("CreationDate", stringBuffer2);
        }
        dict.put("Info", iRef2);
        Dict dict9 = new Dict();
        dict9.put("Type", "Pages");
        IRef iRef3 = new IRef(n6++, 0);
        dict3.put("Pages", iRef3);
        ArrayList<IRef> arrayList2 = new ArrayList<IRef>(100);
        PDFWriter pDFWriter = new PDFWriter(file, pDFReader, true);
        object2 = pDFReader.getCatalog().get("Pages");
        IRef iRef4 = null;
        if (object2 != null && COS.CLASS_IREF == object2.getClass() && COS.CLASS_DICTIONARY == pDFReader.getObject(object2).getClass()) {
            iRef4 = (IRef)object2;
            arrayList2.add(iRef4);
            serializable = (Dict)pDFReader.getObject(object2);
            ((Dict)serializable).put("Parent", iRef3);
            lArray[iRef4.id] = pDFWriter.writeObject((Object)serializable, iRef4.id, iRef4.generation);
            this.mergeSimple(dict3, dict4, pDFReader);
            this.concatOutline(arrayList, pDFReader, 0);
            this.collectNames(dict4, pDFReader, listArray, null, new ArrayList<Object>());
        }
        while (iterator.hasNext()) {
            serializable = iterator.next();
            stringBuffer.append(' ').append(((File)serializable).getName());
            if (!this.fquiet_) {
                this.out_.print(new StringBuffer().append("\t+ ").append(serializable).toString());
            }
            pDFReader = new PDFReader((File)serializable);
            pDFReader.setPassword(this.password_);
            pDFReader.setExact(true);
            if (this.fmonitor_) {
                this.out_.print(new StringBuffer().append(" / ").append(pDFReader.getObjCnt()).append(" objs / ").append(pDFReader.getPageCnt()).append(" pages").toString());
            }
            dict4 = pDFReader.getCatalog();
            this.mergeSimple(dict3, dict4, pDFReader);
            this.concatOutline(arrayList, pDFReader, n6 - 1);
            HashMap<String, StringBuffer> n11 = new HashMap<String, StringBuffer>(100);
            n12 = new ArrayList(100);
            this.collectNames(dict4, pDFReader, listArray, n11, (List<Object>)n12);
            this.rename(pDFReader.getObject(dict4.get("Outlines")), n11, new String[]{"First", "Next", "A", "AA"}, pDFReader, (List<Object>)n12);
            this.rename(pDFReader.getObject(dict4.get("Pages")), n11, new String[]{"Kids", "Annots", "A", "AA"}, pDFReader, (List<Object>)n12);
            n8 += pDFReader.getPageCnt();
            if (pDFReader.getVersion().compareTo(version) > 0) {
                version = pDFReader.getVersion();
            }
            n5 = pDFReader.getObjCnt();
            n4 = n6;
            n3 = n6 + n5 - 1;
            lArray = Arrayss.resize(lArray, n3);
            pDFWriter.setObjCnt(n3);
            object2 = dict4.get("Pages");
            n2 = object2 != null && COS.CLASS_IREF == object2.getClass() ? ((IRef)object2).id : -1;
            pDFReader.fault();
            int n9 = 1;
            while (n9 < n5) {
                n = pDFReader.getObjGen(n9);
                pDFWriter.setObjGen(n4, n);
                if (n != 0 && this.fmonitor_) {
                    System.out.println(new StringBuffer().append("gen = ").append(n).toString());
                }
                object2 = pDFReader.getObject(n9);
                pDFReader.getStreamData(new IRef(n9, n), false, true);
                this.renumber(object2, n6 - 1);
                if (n9 == n2 && COS.CLASS_DICTIONARY == object2.getClass()) {
                    ((Dict)object2).put("Parent", iRef3);
                    arrayList2.add(new IRef(n4, n));
                }
                lArray[n4] = pDFWriter.writeObject(object2, n4, n);
                pDFWriter.setObject(n4, COS.OBJECT_NULL);
                ++n9;
                ++n4;
            }
            n6 = n3;
            if (!$assertionsDisabled && n6 != n4) {
                throw new AssertionError((Object)new StringBuffer().append(n6).append(" + ").append(n5).append(" != ").append(n4).toString());
            }
            pDFReader.close();
            if (this.fquiet_) continue;
            this.out_.println();
        }
        if (arrayList.size() > 0) {
            serializable = new Dict(5);
            int i = n6++;
            n12 = new IRef(i, 0);
            lArray = Arrayss.resize(lArray, n6 += arrayList.size());
            pDFWriter.setObjCnt(n6);
            n4 = 0;
            n2 = arrayList.size();
            for (n3 = 0; n3 < n2; ++n3) {
                Dict dict10 = (Dict)arrayList.get(n3);
                n = i + 1 + n3;
                dict10.put("Parent", n12);
                if (n3 > 0) {
                    dict10.put("Prev", new IRef(n - 1, 0));
                }
                if (n3 + 1 < n2) {
                    dict10.put("Next", new IRef(n + 1, 0));
                }
                lArray[n] = pDFWriter.writeObject((Object)dict10, n, 0);
                object2 = dict10.get("Count");
                if (object2 == null) continue;
                n4 += ((Number)object2).intValue();
            }
            if (n4 > 0) {
                ((Dict)serializable).put("Count", Integers.getInteger(n4));
            }
            ((Dict)serializable).put("First", new IRef(i + 1, 0));
            ((Dict)serializable).put("Last", new IRef(i + 1 + arrayList.size() - 1, 0));
            lArray[i] = pDFWriter.writeObject((Object)serializable, i, 0);
            dict3.put("Outlines", n12);
        }
        serializable = new Dict(5);
        int nArray2 = NAME_TREES.length;
        for (int nArray = 0; nArray < nArray2; ++nArray) {
            ArrayList arrayList3 = listArray[nArray];
            if (arrayList3.size() <= 0) continue;
            lArray = this.writeNames(arrayList3, pDFWriter, lArray);
            ((Dict)serializable).put(NAME_TREES[nArray], new IRef(lArray.length - 1, 0));
        }
        if (((HashMap)serializable).size() > 0) {
            dict3.put("Names", serializable);
            n6 = lArray.length;
        }
        if (version.compareTo(version2) > 0) {
            dict3.put("Version", version.toString());
        }
        lArray[iRef.id] = pDFWriter.writeObject((Object)dict3, iRef.id, 0);
        lArray[iRef2.id] = pDFWriter.writeObject((Object)dict7, iRef2.id, 0);
        dict9.put("Kids", arrayList2.toArray(new Object[arrayList2.size()]));
        dict9.put("Count", Integers.getInteger(n8));
        lArray[iRef3.id] = pDFWriter.writeObject((Object)dict9, iRef3.id, 0);
        if (iRef4 != null) {
            int[] nArray = new int[]{iRef4.id, n7};
            int[] nArray3 = new int[]{1, n6 - n7};
            pDFWriter.writeXref(dict, n6, l, lArray, nArray, nArray3);
        } else {
            pDFWriter.writeXref(dict, n6, l, lArray, n7, n6 - n7);
        }
        pDFWriter.close();
        if (this.fmonitor_) {
            this.out_.println(new StringBuffer().append(file).append(": ").append(n8).append(" pages, ").append(n6).append(" objects").toString());
        }
    }

    private void renumber(Object object, int n) {
        Class<?> clazz = object.getClass();
        if (COS.CLASS_DICTIONARY == clazz) {
            Iterator iterator = ((Dict)object).values().iterator();
            while (iterator.hasNext()) {
                this.renumber(iterator.next(), n);
            }
        } else if (COS.CLASS_ARRAY == clazz) {
            for (Object object2 : (Object[])object) {
                this.renumber(object2, n);
            }
        } else if (COS.CLASS_IREF == clazz) {
            ((IRef)object).id += n;
        }
    }

    private void mergeSimple(Dict dict, Dict dict2, PDFReader pDFReader) throws IOException {
        this.mergeArray(dict, dict2, pDFReader, "Threads");
        this.mergeDict(dict, dict2, pDFReader, "AA");
        this.mergeDict(dict, dict2, pDFReader, "URI");
        Dict dict3 = (Dict)dict.get("AcroForm");
        Dict dict4 = (Dict)pDFReader.getObject(dict2.get("AcroForm"));
        if (dict4 != null) {
            if (dict3 == null) {
                dict.put("AcroForm", dict4);
            } else {
                this.mergeArray(dict3, dict4, pDFReader, "Fields");
                this.mergeArray(dict3, dict4, pDFReader, "CO");
            }
        }
    }

    private void mergeArray(Dict dict, Dict dict2, PDFReader pDFReader, String string) throws IOException {
        Object[] objectArray = (Object[])dict.get(string);
        Object[] objectArray2 = (Object[])pDFReader.getObject(dict2.get(string));
        if (objectArray2 != null) {
            if (objectArray == null) {
                dict.put(string, objectArray2);
            } else {
                dict.put(string, Arrayss.concat(objectArray, objectArray2));
            }
        }
    }

    private void mergeDict(Dict dict, Dict dict2, PDFReader pDFReader, String string) throws IOException {
        Dict dict3 = (Dict)dict.get(string);
        Dict dict4 = (Dict)pDFReader.getObject(dict2.get(string));
        if (dict4 != null) {
            if (dict3 == null) {
                dict.put(string, dict4);
            } else {
                for (Map.Entry entry : dict4.entrySet()) {
                    Object k = entry.getKey();
                    Object v = entry.getValue();
                    Object v2 = dict3.get(k);
                    if (v2 == null) {
                        dict3.put(k, v);
                        continue;
                    }
                    if (v.equals(v2)) continue;
                    this.conflict(new StringBuffer().append("/").append(k).append(" in /").append(string).append(" dict").toString());
                }
            }
        }
    }

    private void concatOutline(List<Dict> list, PDFReader pDFReader, int n) throws IOException {
        Object object;
        IRef iRef;
        Dict dict = pDFReader.getCatalog();
        Dict dict2 = (Dict)pDFReader.getObject(dict.get("Outlines"));
        IRef iRef2 = iRef = pDFReader.getPageCnt() >= 1 ? pDFReader.getPageRef(1) : null;
        if (dict2 != null && this.fsamedoc_ && dict2.get("First") != null && !dict2.get("First").equals(dict2.get("Last"))) {
            object = pDFReader.getObject(dict2.get("First"));
            if (object != null && COS.CLASS_DICTIONARY == object.getClass()) {
                Dict dict3 = (Dict)object;
                while (dict3 != null) {
                    list.add(dict3);
                    dict3 = (Dict)pDFReader.getObject(dict3.get("Next"));
                }
            }
        } else if (dict2 != null) {
            dict2.remove("Type");
            object = dict2.get("Count");
            if (object != null) {
                dict2.put("Count", pDFReader.getObject(object));
            }
            if (iRef != null) {
                iRef = new IRef(iRef);
            }
            list.add(dict2);
        } else {
            dict2 = new Dict(5);
            if (iRef != null) {
                iRef = new IRef(iRef.id + n, iRef.generation);
            }
            list.add(dict2);
        }
        if (!this.fsamedoc_) {
            object = new File(pDFReader.getURI()).getName();
            if (((String)object).endsWith(".pdf")) {
                object = ((String)object).substring(0, ((String)object).length() - 4);
            }
            if (((String)object).endsWith("-m")) {
                object = ((String)object).substring(0, ((String)object).length() - 2);
            }
            dict2.put("Title", new StringBuffer((String)object));
            if (iRef != null) {
                dict2.put("Dest", new Object[]{iRef, "XYZ", COS.OBJECT_NULL, COS.OBJECT_NULL, COS.OBJECT_NULL});
            }
        }
    }

    private void collectNames(Dict dict, PDFReader pDFReader, List[] listArray, Map<String, StringBuffer> map, List<Object> list) throws IOException {
        block5: {
            Object object;
            block4: {
                object = dict.get("Names");
                if (object == null) break block4;
                Dict dict2 = (Dict)pDFReader.getObject(object);
                list.add(dict2);
                int n = NAME_TREES.length;
                for (int i = 0; i < n; ++i) {
                    String string = NAME_TREES[i];
                    Dict dict3 = (Dict)pDFReader.getObject(dict2.get(string));
                    if (dict3 == null) continue;
                    this.collectNames(string, dict3, pDFReader, listArray[i], i == 0 ? map : null, list);
                }
                break block5;
            }
            object = dict.get("Dests");
            if (object == null) break block5;
            if (!$assertionsDisabled && NAME_TREES[0] != "Dests") {
                throw new AssertionError();
            }
            if (this.fmonitor_) {
                this.out_.println("   (old style /Dests)");
            }
            Dict dict4 = (Dict)pDFReader.getObject(object);
            list.add(dict4);
            for (Map.Entry entry : dict4.entrySet()) {
                String string = (String)entry.getKey();
                this.addName(new StringBuffer(string), string, entry.getValue(), listArray[0], map);
            }
        }
    }

    private void collectNames(String string, Dict dict, PDFReader pDFReader, List<NamePair> list, Map<String, StringBuffer> map, List<Object> list2) throws IOException {
        Object[] objectArray = (Object[])pDFReader.getObject(dict.get("Kids"));
        if (objectArray != null) {
            for (Object object : objectArray) {
                if (COS.OBJECT_NULL == (object = pDFReader.getObject(object))) continue;
                this.collectNames(string, (Dict)object, pDFReader, list, map, list2);
            }
        } else {
            list2.add(dict);
            Object[] objectArray2 = (Object[])pDFReader.getObject(dict.get("Names"));
            int n = objectArray2.length;
            for (int i = 0; i < n; i += 2) {
                Object object = pDFReader.getObject(objectArray2[i]);
                if (COS.OBJECT_NULL == object) continue;
                StringBuffer stringBuffer = (StringBuffer)object;
                Object object2 = objectArray2[i + 1];
                this.addName(stringBuffer, stringBuffer.toString(), objectArray2[i + 1], list, map);
            }
        }
    }

    private void addName(StringBuffer stringBuffer, String string, Object object, List<NamePair> list, Map<String, StringBuffer> map) {
        String string2 = string;
        int n = list.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (!string2.equals(list.get((int)i).str_)) continue;
            string2 = new StringBuffer().append(string).append("_").append(n2++).toString();
            stringBuffer = new StringBuffer(string2);
            i = -1;
        }
        list.add(new NamePair(stringBuffer, string2, object));
        if (string != string2) {
            if (map != null) {
                map.put(string, stringBuffer);
            } else {
                System.err.print(new StringBuffer().append("   CONFLICT: ").append(string).append(" -- discarded.").toString());
            }
            if (this.fmonitor_) {
                this.out_.println(new StringBuffer().append("\t").append(string).append(" => ").append(string2).toString());
            }
        }
    }

    private void rename(Object object, Map<String, StringBuffer> map, String[] stringArray, PDFReader pDFReader, List<Object> list) throws IOException {
        block6: {
            Class<?> clazz;
            block5: {
                if (object == null || map.size() == 0) {
                    return;
                }
                clazz = object.getClass();
                if (COS.CLASS_ARRAY != clazz) break block5;
                for (Object object2 : (Object[])object) {
                    this.rename(pDFReader.getObject(object2), map, stringArray, pDFReader, list);
                }
                break block6;
            }
            if (COS.CLASS_DICTIONARY != clazz) break block6;
            for (Map.Entry entry : ((Dict)object).entrySet()) {
                Object k = entry.getKey();
                Object object3 = pDFReader.getObject(entry.getValue());
                if (("Dest".equals(k) || "D".equals(k)) && (COS.CLASS_STRING == object3.getClass() || COS.CLASS_NAME == object3.getClass())) {
                    String string = object3.toString();
                    StringBuffer stringBuffer = map.get(string);
                    if (stringBuffer != null) {
                        entry.setValue(stringBuffer);
                        list.add(object);
                        if (!this.fmonitor_) continue;
                        this.out_.println(new StringBuffer().append(" renaming ").append(object3).append(" => ").append((Object)stringBuffer).toString());
                        continue;
                    }
                    if (COS.CLASS_NAME != object3.getClass()) continue;
                    entry.setValue(new StringBuffer(string));
                    list.add(object);
                    if (!this.fmonitor_) continue;
                    this.out_.println(new StringBuffer().append(" updating /").append(object3).append(" => (").append(string).append(") in ").append(object).toString());
                    continue;
                }
                if (Arrayss.indexOf(stringArray, k) == -1) continue;
                this.rename(object3, map, stringArray, pDFReader, list);
            }
        }
    }

    private long[] writeNames(List<NamePair> list, PDFWriter pDFWriter, long[] lArray) throws IOException {
        int n;
        Object[] objectArray = list.toArray(new NamePair[list.size()]);
        Arrays.sort(objectArray);
        LinkedList<Dict> linkedList = new LinkedList<Dict>();
        int n2 = 0;
        int n3 = objectArray.length;
        while (n2 < n3) {
            Dict dict = new Dict(5);
            Object[] objectArray2 = new Object[Math.min(50, n3 - n2) * 2];
            int n4 = objectArray2.length;
            for (int i = 0; i < n4; i += 2) {
                objectArray2[i] = ((NamePair)objectArray[n2]).name_;
                objectArray2[i + 1] = ((NamePair)objectArray[n2]).value_;
                ++n2;
            }
            dict.put("Names", objectArray2);
            dict.put("Limits", new Object[]{objectArray2[0], objectArray2[objectArray2.length - 1 - 1]});
            linkedList.add(dict);
        }
        n2 = lArray.length;
        int n5 = linkedList.size();
        for (n3 = 0; n3 < n5; n3 += n) {
            Dict dict;
            n = Math.min(n5 - n3, 50);
            if (n == 1) {
                dict = (Dict)linkedList.get(n3);
                dict.remove("Limits");
            } else {
                dict = new Dict(5);
                Object[] objectArray3 = (Object[])((Dict)linkedList.get(0)).get("Limits");
                Object[] objectArray4 = (Object[])((Dict)linkedList.get(n - 1)).get("Limits");
                dict.put("Limits", new Object[]{objectArray3[0], objectArray4[1]});
                Object[] objectArray5 = new Object[n];
                for (int i = 0; i < n; ++i) {
                    objectArray5[i] = new IRef(n2 + n3 + i, 0);
                }
                dict.put("Kids", objectArray5);
                linkedList.add(dict);
            }
            n5 = linkedList.size();
        }
        n3 = lArray.length + linkedList.size();
        lArray = Arrayss.resize(lArray, n3);
        pDFWriter.setObjCnt(n3);
        int n6 = linkedList.size();
        for (n5 = 0; n5 < n6; ++n5) {
            lArray[n2 + n5] = pDFWriter.writeObject(linkedList.get(n5), n2 + n5, 0);
        }
        return lArray;
    }

    private void conflict(String string) {
        if (!this.fquiet_ && !this.fsamedoc_) {
            System.err.print(new StringBuffer().append("   CONFLICT: ").append(string).append(" -- discarded.").toString());
        }
    }

    private int commandLine(String[] stringArray) {
        String string;
        int n;
        this.out_ = System.out;
        int n2 = stringArray.length;
        for (n = 0; n < n2 && (string = stringArray[n]).startsWith("-"); ++n) {
            if ((string = string.toLowerCase()).startsWith("--")) {
                string = string.substring(1);
            }
            if (string.startsWith("-append")) {
                this.fappend_ = true;
                continue;
            }
            if (string.startsWith("-same")) {
                this.fsamedoc_ = true;
                continue;
            }
            if (string.startsWith("-pass")) {
                this.password_ = stringArray[++n];
                continue;
            }
            if (string.startsWith("-verb")) {
                this.fverbose_ = true;
                this.fquiet_ = false;
                continue;
            }
            if (string.startsWith("-mon")) {
                this.fverbose_ = true;
                this.fmonitor_ = true;
                this.fquiet_ = false;
                continue;
            }
            if (string.startsWith("-q")) {
                this.fquiet_ = true;
                this.fverbose_ = false;
                this.fmonitor_ = false;
                continue;
            }
            if (string.startsWith("-v")) {
                System.out.println(VERSION);
                System.exit(0);
                continue;
            }
            if (string.startsWith("-h")) {
                System.out.println(USAGE);
                System.exit(0);
                continue;
            }
            System.err.println(new StringBuffer().append("Unknown option: ").append(string).toString());
            System.err.println(USAGE);
            System.exit(1);
        }
        if (n == n2) {
            System.err.println(USAGE);
            System.exit(0);
        }
        return n;
    }

    public static void main(String[] stringArray) {
        Merge merge = new Merge();
        int n = merge.commandLine(stringArray);
        if (System.getSecurityManager() == null) {
            try {
                if (merge.fappend_) {
                    File file = Files.getFile(stringArray[n++]);
                    merge.merge(file, new FileList(stringArray, n, COS.FILTER));
                } else {
                    merge.merge(new FileList(stringArray, n, COS.FILTER), null);
                }
            }
            catch (Exception exception) {
                System.err.println(new StringBuffer().append("FAILED: ").append(exception).toString());
            }
        }
        System.exit(0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        $assertionsDisabled = !(class$tool$pdf$Merge == null ? (class$tool$pdf$Merge = Merge.class$("tool.pdf.Merge")) : class$tool$pdf$Merge).desiredAssertionStatus();
        NAME_TREES = new String[]{"Dests", "AP", "JavaScript", "Pages", "Templates", "IDS", "URLS", "EmbeddedFiles", "AlternatePresentations", "Renditions"};
    }

    static class NamePair
    implements Comparable {
        StringBuffer name_;
        Object value_;
        String str_;

        NamePair(StringBuffer stringBuffer, String string, Object object) {
            this.name_ = stringBuffer;
            this.str_ = string;
            this.value_ = object;
        }

        public int compareTo(Object object) {
            if (object == null) {
                throw new NullPointerException();
            }
            NamePair namePair = (NamePair)object;
            return this.str_.compareTo(namePair.str_);
        }
    }
}

