/*
 * Decompiled with CFR 0.152.
 */
package phelps.lang;

import java.util.Arrays;

public class Integers {
    public static final int[] ARRAY0;
    public static final Integer ZERO;
    public static final Integer ONE;
    public static final Integer TWO;
    private static final int INTS_MIN = -100;
    private static final int INTS_MAX = 1000;
    private static Integer[] INTS;
    private static final int STRS_MIN = -10;
    private static final int STRS_MAX = 100;
    private static String[] STRS;
    private static final String[] ROMAN;
    private static int[] RADIX;
    private static final byte[] BIT_COUNT;
    static final /* synthetic */ boolean $assertionsDisabled;

    private Integers() {
    }

    public static int parseInt(String string, int n) {
        if (string == null) {
            return n;
        }
        try {
            return Integer.parseInt(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public static int parseInt(int n) {
        if (RADIX == null) {
            RADIX = new int[256];
            Arrays.fill(RADIX, -1);
            int n2 = 0;
            int n3 = 48;
            while (n2 < 10) {
                Integers.RADIX[n3] = n2++;
                ++n3;
            }
            n2 = 10;
            n3 = 97;
            int n4 = 65;
            while (n3 <= 122) {
                Integers.RADIX[n3] = Integers.RADIX[n4] = n2++;
                ++n3;
                ++n4;
            }
        }
        return 0 <= n && n <= 255 ? RADIX[n] : -1;
    }

    public static int parseHex(int n, int n2) {
        return Integers.parseInt(n) << 4 | Integers.parseInt(n2);
    }

    public static Integer getInteger(int n) {
        Integer n2;
        if (-100 <= n && n <= 1000) {
            if (INTS == null) {
                INTS = new Integer[1101];
                Integers.INTS[100] = ZERO;
                Integers.INTS[101] = ONE;
                Integers.INTS[102] = TWO;
            }
            if ((n2 = INTS[n - -100]) == null) {
                Integer n3 = new Integer(n);
                Integers.INTS[n - -100] = n3;
                n2 = n3;
            }
        } else {
            n2 = new Integer(n);
        }
        return n2;
    }

    public static String toRomanString(int n) {
        if (n <= 0 || n >= 4000) {
            return Integer.toString(n);
        }
        if (n < ROMAN.length) {
            return ROMAN[n];
        }
        StringBuffer stringBuffer = new StringBuffer(10);
        while (n >= 1000) {
            stringBuffer.append('M');
            n -= 1000;
        }
        if (n >= 900) {
            stringBuffer.append("CM");
            n -= 900;
        }
        if (n >= 500) {
            stringBuffer.append('D');
            n -= 500;
        }
        if (n >= 400) {
            stringBuffer.append("CD");
            n -= 400;
        }
        while (n >= 100) {
            stringBuffer.append('C');
            n -= 100;
        }
        if (n >= 90) {
            stringBuffer.append("XC");
            n -= 90;
        }
        if (n >= 50) {
            stringBuffer.append('L');
            n -= 50;
        }
        if (!$assertionsDisabled && ROMAN.length < 50) {
            throw new AssertionError();
        }
        if (n > 0) {
            stringBuffer.append(ROMAN[n]);
        }
        return stringBuffer.toString();
    }

    public static int bitCount(int n) {
        return BIT_COUNT[n & 0xFF] + BIT_COUNT[n >> 8 & 0xFF] + BIT_COUNT[n >> 16 & 0xFF] + BIT_COUNT[n >> 24 & 0xFF];
    }

    public static String toString(int n) {
        String string;
        if (-10 <= n && n <= 100) {
            if (STRS == null) {
                STRS = new String[111];
            }
            if ((string = STRS[n - -10]) == null) {
                String string2 = Integer.toString(n);
                Integers.STRS[n - -10] = string2;
                string = string2;
            }
        } else {
            string = Integer.toString(n);
        }
        return string;
    }

    static {
        $assertionsDisabled = !Integers.class.desiredAssertionStatus();
        ARRAY0 = new int[0];
        ZERO = new Integer(0);
        ONE = new Integer(1);
        TWO = new Integer(2);
        INTS = null;
        STRS = null;
        ROMAN = new String[]{"(no zero)", "I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX", "X", "XI", "XII", "XIII", "XIV", "XV", "XVI", "XVII", "XVIII", "XIX", "XX", "XXI", "XXII", "XXIII", "XXIV", "XXV", "XXVI", "XXVII", "XXVIII", "XXIX", "XXX", "XXXI", "XXXII", "XXXIII", "XXXIV", "XXXV", "XXXVI", "XXXVII", "XXXVIII", "XXXIX", "XL", "XLI", "XLII", "XLIII", "XLIV", "XLV", "XLVI", "XLVII", "XLVIII", "XLIX"};
        RADIX = null;
        BIT_COUNT = new byte[256];
        Integers.BIT_COUNT[0] = 0;
        for (int i = 1; i < 256; i *= 2) {
            for (int j = 0; j < i; ++j) {
                Integers.BIT_COUNT[i + j] = (byte)(BIT_COUNT[j] + 1);
            }
        }
    }
}

