/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.bzip2;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.tools.bzip2.BZip2Constants;
import org.apache.tools.bzip2.CRC;

public class CBZip2OutputStream
extends OutputStream
implements BZip2Constants {
    protected static final int SETMASK = 0x200000;
    protected static final int CLEARMASK = -2097153;
    protected static final char GREATER_ICOST = '\u000f';
    protected static final char LESSER_ICOST = '\u0000';
    protected static final int SMALL_THRESH = 20;
    protected static final int DEPTH_THRESH = 10;
    protected static final int QSORT_STACK_SIZE = 200;
    int last;
    int origPtr;
    int blockSize100k;
    boolean blockRandomised;
    int bytesIn;
    int bytesOut;
    int bsBuff;
    int bsLive;
    CRC mCrc = new CRC();
    private boolean[] inUse = new boolean[256];
    private int nInUse;
    private char[] seqToUnseq = new char[256];
    private char[] unseqToSeq = new char[256];
    private char[] selector = new char[18002];
    private char[] selectorMtf = new char[18002];
    private char[] block = null;
    private int[] quadrant;
    private int[] zptr = null;
    private short[] szptr;
    private int nMTF;
    private int[] mtfFreq = new int[258];
    private int workFactor;
    private int workDone;
    private int workLimit;
    private boolean firstAttempt;
    private int nBlocksRandomised;
    private int currentChar = -1;
    private int runLength = 0;
    boolean closed = false;
    private int combinedCRC;
    private int allowableBlockSize;
    private OutputStream bsStream;
    private StackElem[] qstack = new StackElem[200];
    private final int[] incs = new int[]{1, 4, 13, 40, 121, 364, 1093, 3280, 9841, 29524, 88573, 265720, 797161, 2391484};
    static final /* synthetic */ boolean $assertionsDisabled;

    private void makeMaps() {
        this.nInUse = 0;
        for (int i = 0; i < 256; ++i) {
            if (!this.inUse[i]) continue;
            this.seqToUnseq[this.nInUse] = (char)i;
            this.unseqToSeq[i] = (char)this.nInUse;
            ++this.nInUse;
        }
    }

    protected static void hbMakeCodeLengths(char[] cArray, int[] nArray, int n, int n2) {
        int n3;
        int[] nArray2 = new int[260];
        int[] nArray3 = new int[516];
        int[] nArray4 = new int[516];
        for (n3 = 0; n3 < n; ++n3) {
            nArray3[n3 + 1] = (nArray[n3] == 0 ? 1 : nArray[n3]) << 8;
        }
        block1: while (true) {
            int n4;
            int n5;
            int n6;
            int n7 = n;
            int n8 = 0;
            nArray2[0] = 0;
            nArray3[0] = 0;
            nArray4[0] = -2;
            for (n3 = 1; n3 <= n; ++n3) {
                nArray4[n3] = -1;
                nArray2[++n8] = n3;
                n6 = n8;
                n5 = nArray2[n6];
                while (nArray3[n5] < nArray3[nArray2[n6 >> 1]]) {
                    nArray2[n6] = nArray2[n6 >> 1];
                    n6 >>= 1;
                }
                nArray2[n6] = n5;
            }
            if (!$assertionsDisabled && n8 >= 260) {
                throw new AssertionError();
            }
            while (n8 > 1) {
                int n9 = nArray2[1];
                nArray2[1] = nArray2[n8];
                --n8;
                n6 = 0;
                n5 = 0;
                int n10 = 0;
                n6 = 1;
                n10 = nArray2[n6];
                while ((n5 = n6 << 1) <= n8) {
                    if (n5 < n8 && nArray3[nArray2[n5 + 1]] < nArray3[nArray2[n5]]) {
                        ++n5;
                    }
                    if (nArray3[n10] < nArray3[nArray2[n5]]) break;
                    nArray2[n6] = nArray2[n5];
                    n6 = n5;
                }
                nArray2[n6] = n10;
                int n11 = nArray2[1];
                nArray2[1] = nArray2[n8];
                --n8;
                n6 = 0;
                n5 = 0;
                n10 = 0;
                n6 = 1;
                n10 = nArray2[n6];
                while ((n5 = n6 << 1) <= n8) {
                    if (n5 < n8 && nArray3[nArray2[n5 + 1]] < nArray3[nArray2[n5]]) {
                        ++n5;
                    }
                    if (nArray3[n10] < nArray3[nArray2[n5]]) break;
                    nArray2[n6] = nArray2[n5];
                    n6 = n5;
                }
                nArray2[n6] = n10;
                nArray4[n9] = nArray4[n11] = ++n7;
                nArray3[n7] = (nArray3[n9] & 0xFFFFFF00) + (nArray3[n11] & 0xFFFFFF00) | 1 + ((nArray3[n9] & 0xFF) > (nArray3[n11] & 0xFF) ? nArray3[n9] & 0xFF : nArray3[n11] & 0xFF);
                nArray4[n7] = -1;
                nArray2[++n8] = n7;
                n6 = 0;
                n5 = 0;
                n6 = n8;
                n5 = nArray2[n6];
                while (nArray3[n5] < nArray3[nArray2[n6 >> 1]]) {
                    nArray2[n6] = nArray2[n6 >> 1];
                    n6 >>= 1;
                }
                nArray2[n6] = n5;
            }
            if (!$assertionsDisabled && n7 >= 516) {
                throw new AssertionError();
            }
            boolean bl = false;
            for (n3 = 1; n3 <= n; ++n3) {
                n4 = 0;
                int n12 = n3;
                while (nArray4[n12] >= 0) {
                    n12 = nArray4[n12];
                    ++n4;
                }
                cArray[n3 - 1] = (char)n4;
                if (n4 <= n2) continue;
                bl = true;
            }
            if (!bl) break;
            n3 = 1;
            while (true) {
                if (n3 >= n) continue block1;
                n4 = nArray3[n3] >> 8;
                n4 = 1 + n4 / 2;
                nArray3[n3] = n4 << 8;
                ++n3;
            }
            break;
        }
    }

    public CBZip2OutputStream(OutputStream outputStream) throws IOException {
        this(outputStream, 9);
    }

    public CBZip2OutputStream(OutputStream outputStream, int n) throws IOException {
        this.bsSetStream(outputStream);
        this.workFactor = 50;
        this.blockSize100k = n < 1 ? 1 : (n > 9 ? 9 : n);
        this.allocateCompressStructures();
        this.initialize();
        this.initBlock();
    }

    public void write(int n) throws IOException {
        int n2 = n & 0xFF;
        if (this.currentChar != -1) {
            if (this.currentChar == n2) {
                ++this.runLength;
                if (this.runLength > 254) {
                    this.writeRun();
                    this.currentChar = -1;
                    this.runLength = 0;
                }
            } else {
                this.writeRun();
                this.runLength = 1;
                this.currentChar = n2;
            }
        } else {
            this.currentChar = n2;
            ++this.runLength;
        }
    }

    private void writeRun() throws IOException {
        if (this.last < this.allowableBlockSize) {
            this.inUse[this.currentChar] = true;
            for (int i = 0; i < this.runLength; ++i) {
                this.mCrc.updateCRC(this.currentChar);
            }
            switch (this.runLength) {
                case 1: {
                    this.block[this.last++] = (char)this.currentChar;
                    break;
                }
                case 2: {
                    this.block[this.last++] = (char)this.currentChar;
                    this.block[this.last++] = (char)this.currentChar;
                    break;
                }
                case 3: {
                    this.block[this.last++] = (char)this.currentChar;
                    this.block[this.last++] = (char)this.currentChar;
                    this.block[this.last++] = (char)this.currentChar;
                    break;
                }
                default: {
                    this.inUse[this.runLength - 4] = true;
                    this.block[this.last++] = (char)this.currentChar;
                    this.block[this.last++] = (char)this.currentChar;
                    this.block[this.last++] = (char)this.currentChar;
                    this.block[this.last++] = (char)this.currentChar;
                    this.block[this.last++] = (char)(this.runLength - 4);
                    break;
                }
            }
        } else {
            this.endBlock();
            this.initBlock();
            this.writeRun();
        }
    }

    public void finalize() throws Throwable {
        this.close();
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        if (this.runLength > 0) {
            this.writeRun();
        }
        this.currentChar = -1;
        this.endBlock();
        this.endCompression();
        this.closed = true;
        super.close();
        this.bsStream.close();
    }

    public void flush() throws IOException {
        super.flush();
        this.bsStream.flush();
    }

    private void initialize() throws IOException {
        this.bytesIn = 0;
        this.bytesOut = 0;
        this.nBlocksRandomised = 0;
        this.bsPutUChar(104);
        this.bsPutUChar(48 + this.blockSize100k);
        this.combinedCRC = 0;
        for (int i = 0; i < 200; ++i) {
            this.qstack[i] = new StackElem();
        }
    }

    private void initBlock() {
        this.mCrc.initialiseCRC();
        this.last = 1;
        for (int i = 0; i < 256; ++i) {
            this.inUse[i] = false;
        }
        this.allowableBlockSize = 100000 * this.blockSize100k - 20 + 2;
    }

    private void endBlock() throws IOException {
        this.last -= 2;
        int n = this.mCrc.getFinalCRC();
        this.combinedCRC = this.combinedCRC << 1 | this.combinedCRC >>> 31;
        this.combinedCRC ^= n;
        this.doReversibleTransformation();
        this.bsPutUChar(49);
        this.bsPutUChar(65);
        this.bsPutUChar(89);
        this.bsPutUChar(38);
        this.bsPutUChar(83);
        this.bsPutUChar(89);
        this.bsPutint(n);
        if (this.blockRandomised) {
            this.bsW(1, 1);
            ++this.nBlocksRandomised;
        } else {
            this.bsW(1, 0);
        }
        this.moveToFrontCodeAndSend();
    }

    private void endCompression() throws IOException {
        this.bsPutUChar(23);
        this.bsPutUChar(114);
        this.bsPutUChar(69);
        this.bsPutUChar(56);
        this.bsPutUChar(80);
        this.bsPutUChar(144);
        this.bsPutint(this.combinedCRC);
        this.bsFinishedWithStream();
    }

    private void hbAssignCodes(int[] nArray, char[] cArray, int n, int n2, int n3) {
        int n4 = 0;
        for (int i = n; i <= n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                if (cArray[j] != i) continue;
                nArray[j] = n4++;
            }
            n4 <<= 1;
        }
    }

    private void bsSetStream(OutputStream outputStream) {
        this.bsStream = outputStream;
        this.bsLive = 0;
        this.bsBuff = 0;
        this.bytesOut = 0;
        this.bytesIn = 0;
    }

    private void bsFinishedWithStream() throws IOException {
        while (this.bsLive > 0) {
            int n = this.bsBuff >> 24;
            this.bsStream.write(n);
            this.bsBuff <<= 8;
            this.bsLive -= 8;
            ++this.bytesOut;
        }
    }

    private void bsW(int n, int n2) throws IOException {
        while (this.bsLive >= 8) {
            int n3 = this.bsBuff >> 24;
            this.bsStream.write(n3);
            this.bsBuff <<= 8;
            this.bsLive -= 8;
            ++this.bytesOut;
        }
        this.bsBuff |= n2 << 32 - this.bsLive - n;
        this.bsLive += n;
    }

    private void bsPutUChar(int n) throws IOException {
        this.bsW(8, n);
    }

    private void bsPutint(int n) throws IOException {
        this.bsW(8, n >> 24 & 0xFF);
        this.bsW(8, n >> 16 & 0xFF);
        this.bsW(8, n >> 8 & 0xFF);
        this.bsW(8, n & 0xFF);
    }

    private void bsPutIntVS(int n, int n2) throws IOException {
        this.bsW(n, n2);
    }

    private void sendMTFValues() throws IOException {
        int n;
        int n2;
        short s;
        short s2;
        short s3;
        int n3;
        int n4;
        int n5;
        int n6;
        char[][] cArray = new char[6][258];
        int n7 = 0;
        int n8 = this.nInUse + 2;
        for (n6 = 0; n6 < 6; ++n6) {
            for (n5 = 0; n5 < n8; ++n5) {
                cArray[n6][n5] = 15;
            }
        }
        if (!$assertionsDisabled && this.nMTF <= 0) {
            throw new AssertionError(this.nMTF);
        }
        int n9 = this.nMTF < 200 ? 2 : (this.nMTF < 600 ? 3 : (this.nMTF < 1200 ? 4 : (this.nMTF < 2400 ? 5 : 6)));
        int n10 = n9;
        int n11 = this.nMTF;
        int n12 = 0;
        while (n10 > 0) {
            int n13 = n11 / n10;
            n4 = n12 - 1;
            for (n3 = 0; n3 < n13 && n4 < n8 - 1; n3 += this.mtfFreq[++n4]) {
            }
            if (n4 > n12 && n10 != n9 && n10 != 1 && (n9 - n10 & 1) == 1) {
                n3 -= this.mtfFreq[n4];
                --n4;
            }
            for (n5 = 0; n5 < n8; ++n5) {
                cArray[n10 - 1][n5] = n12 <= n5 && n5 <= n4 ? 0 : 15;
            }
            --n10;
            n12 = n4 + 1;
            n11 -= n3;
        }
        int[][] nArray = new int[6][258];
        int[] nArray2 = new int[6];
        short[] sArray = new short[6];
        for (int i = 0; i < 4; ++i) {
            for (n6 = 0; n6 < n9; ++n6) {
                nArray2[n6] = 0;
            }
            for (n6 = 0; n6 < n9; ++n6) {
                for (n5 = 0; n5 < n8; ++n5) {
                    nArray[n6][n5] = 0;
                }
            }
            n7 = 0;
            int n14 = 0;
            n12 = 0;
            while (n12 < this.nMTF) {
                n4 = n12 + 50 - 1;
                if (n4 >= this.nMTF) {
                    n4 = this.nMTF - 1;
                }
                for (n6 = 0; n6 < n9; ++n6) {
                    sArray[n6] = 0;
                }
                if (n9 == 6) {
                    n3 = 0;
                    s3 = 0;
                    s2 = 0;
                    s = 0;
                    short s4 = 0;
                    short s5 = 0;
                    for (n2 = n12; n2 <= n4; ++n2) {
                        short s6 = this.szptr[n2];
                        n3 = (short)(n3 + cArray[0][s6]);
                        s3 = (short)(s3 + cArray[1][s6]);
                        s2 = (short)(s2 + cArray[2][s6]);
                        s = (short)(s + cArray[3][s6]);
                        s4 = (short)(s4 + cArray[4][s6]);
                        s5 = (short)(s5 + cArray[5][s6]);
                    }
                    sArray[0] = n3;
                    sArray[1] = s3;
                    sArray[2] = s2;
                    sArray[3] = s;
                    sArray[4] = s4;
                    sArray[5] = s5;
                } else {
                    for (n2 = n12; n2 <= n4; ++n2) {
                        n3 = this.szptr[n2];
                        for (n6 = 0; n6 < n9; ++n6) {
                            int n13 = n6;
                            sArray[n13] = (short)(sArray[n13] + cArray[n6][n3]);
                        }
                    }
                }
                short s7 = 999999999;
                int n16 = -1;
                for (n6 = 0; n6 < n9; ++n6) {
                    if (sArray[n6] >= s7) continue;
                    s7 = sArray[n6];
                    n16 = n6;
                }
                n14 += s7;
                int n15 = n16;
                nArray2[n15] = nArray2[n15] + 1;
                this.selector[n7] = (char)n16;
                ++n7;
                for (n2 = n12; n2 <= n4; ++n2) {
                    int[] nArray3 = nArray[n16];
                    short s4 = this.szptr[n2];
                    nArray3[s4] = nArray3[s4] + 1;
                }
                n12 = n4 + 1;
            }
            for (n6 = 0; n6 < n9; ++n6) {
                CBZip2OutputStream.hbMakeCodeLengths(cArray[n6], nArray[n6], n8, 20);
            }
        }
        nArray = null;
        nArray2 = null;
        sArray = null;
        if (!$assertionsDisabled && n9 >= 8) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || n7 < 32768 && n7 <= 18002)) {
            throw new AssertionError();
        }
        Object object = new char[6];
        for (n2 = 0; n2 < n9; ++n2) {
            object[n2] = (char)n2;
        }
        for (n2 = 0; n2 < n7; ++n2) {
            s3 = this.selector[n2];
            n = 0;
            s = object[n];
            while (s3 != s) {
                s2 = s;
                s = object[++n];
                object[n] = s2;
            }
            object[0] = s;
            this.selectorMtf[n2] = (char)n;
        }
        object = new int[6][258];
        for (n6 = 0; n6 < n9; ++n6) {
            char c = ' ';
            char c2 = '\u0000';
            for (n2 = 0; n2 < n8; ++n2) {
                if (cArray[n6][n2] > c2) {
                    c2 = cArray[n6][n2];
                }
                if (cArray[n6][n2] >= c) continue;
                c = cArray[n6][n2];
            }
            if (!($assertionsDisabled || c >= '\u0001' && c2 <= '\u0014')) {
                throw new AssertionError();
            }
            this.hbAssignCodes((int[])object[n6], cArray[n6], c, c2, n8);
        }
        boolean[] blArray = new boolean[16];
        for (n2 = 0; n2 < 16; ++n2) {
            for (n = 0; n < 16; ++n) {
                if (!this.inUse[n2 * 16 + n]) continue;
                blArray[n2] = true;
            }
        }
        int n18 = this.bytesOut;
        for (n2 = 0; n2 < 16; ++n2) {
            this.bsW(1, blArray[n2] ? 1 : 0);
        }
        for (n2 = 0; n2 < 16; ++n2) {
            if (!blArray[n2]) continue;
            for (n = 0; n < 16; ++n) {
                this.bsW(1, this.inUse[n2 * 16 + n] ? 1 : 0);
            }
        }
        n18 = this.bytesOut;
        this.bsW(3, n9);
        this.bsW(15, n7);
        for (n2 = 0; n2 < n7; ++n2) {
            int n19 = this.selectorMtf[n2];
            for (n = 0; n < n19; ++n) {
                this.bsW(1, 1);
            }
            this.bsW(1, 0);
        }
        n18 = this.bytesOut;
        for (n6 = 0; n6 < n9; ++n6) {
            int n20 = cArray[n6][0];
            this.bsW(5, n20);
            for (n2 = 0; n2 < n8; ++n2) {
                while (n20 < cArray[n6][n2]) {
                    this.bsW(2, 2);
                    ++n20;
                }
                while (n20 > cArray[n6][n2]) {
                    this.bsW(2, 3);
                    --n20;
                }
                this.bsW(1, 0);
            }
        }
        n18 = this.bytesOut;
        int n21 = 0;
        n12 = 0;
        while (n12 < this.nMTF) {
            n4 = n12 + 50 - 1;
            if (n4 >= this.nMTF) {
                n4 = this.nMTF - 1;
            }
            for (n2 = n12; n2 <= n4; ++n2) {
                this.bsW(cArray[this.selector[n21]][this.szptr[n2]], (int)object[this.selector[n21]][this.szptr[n2]]);
            }
            n12 = n4 + 1;
            ++n21;
        }
        if (!$assertionsDisabled && n21 != n7) {
            throw new AssertionError();
        }
    }

    private void moveToFrontCodeAndSend() throws IOException {
        this.bsPutIntVS(24, this.origPtr);
        this.generateMTFValues();
        this.sendMTFValues();
    }

    private void simpleSort(int n, int n2, int n3) {
        int n4 = n2 - n + 1;
        if (n4 <= 1) {
            return;
        }
        int n5 = 0;
        while (this.incs[n5] < n4) {
            ++n5;
        }
        --n5;
        while (n5 >= 0) {
            int n6 = this.incs[n5];
            for (int i = n + n6; i <= n2; ++i) {
                int n7 = this.zptr[i];
                int n8 = i;
                while (this.fullGtU(this.zptr[n8 - n6] + n3, n7 + n3)) {
                    this.zptr[n8] = this.zptr[n8 - n6];
                    if ((n8 -= n6) > n + n6 - 1) continue;
                }
                this.zptr[n8] = n7;
                if (++i > n2) break;
                n7 = this.zptr[i];
                n8 = i;
                while (this.fullGtU(this.zptr[n8 - n6] + n3, n7 + n3)) {
                    this.zptr[n8] = this.zptr[n8 - n6];
                    if ((n8 -= n6) > n + n6 - 1) continue;
                }
                this.zptr[n8] = n7;
                if (++i > n2) break;
                n7 = this.zptr[i];
                n8 = i;
                while (this.fullGtU(this.zptr[n8 - n6] + n3, n7 + n3)) {
                    this.zptr[n8] = this.zptr[n8 - n6];
                    if ((n8 -= n6) > n + n6 - 1) continue;
                }
                this.zptr[n8] = n7;
                if (this.workDone <= this.workLimit || !this.firstAttempt) continue;
                return;
            }
            --n5;
        }
    }

    private void vswap(int n, int n2, int n3) {
        while (n3 > 0) {
            int n4 = this.zptr[n];
            this.zptr[n] = this.zptr[n2];
            this.zptr[n2] = n4;
            ++n;
            ++n2;
            --n3;
        }
    }

    private char med3(char c, char c2, char c3) {
        char c4 = c < c2 ? (c2 <= c3 ? c2 : (c < c3 ? c3 : c)) : (c3 >= c ? c : (c3 > c2 ? c3 : c2));
        return c4;
    }

    private void qSort3(int n, int n2, int n3) {
        StackElem[] stackElemArray = this.qstack;
        int n4 = 0;
        StackElem stackElem = stackElemArray[n4++];
        stackElem.ll = n;
        stackElem.hh = n2;
        stackElem.dd = n3;
        while (n4 > 0) {
            int n5;
            int n6;
            int n7;
            if (!$assertionsDisabled && n4 >= 200) {
                throw new AssertionError(n4);
            }
            stackElem = stackElemArray[--n4];
            int n8 = stackElem.ll;
            int n9 = stackElem.hh;
            int n10 = stackElem.dd;
            if (n9 - n8 < 20 || n10 > 10) {
                this.simpleSort(n8, n9, n10);
                if (this.workDone <= this.workLimit || !this.firstAttempt) continue;
                return;
            }
            char c = this.med3(this.block[this.zptr[n8] + n10 + 1], this.block[this.zptr[n9] + n10 + 1], this.block[this.zptr[n8 + n9 >> 1] + n10 + 1]);
            int n11 = n7 = n8;
            int n12 = n6 = n9;
            while (true) {
                int n13;
                if (n11 <= n12) {
                    n5 = this.block[this.zptr[n11] + n10 + 1] - c;
                    if (n5 == 0) {
                        n13 = this.zptr[n11];
                        this.zptr[n11] = this.zptr[n7];
                        this.zptr[n7] = n13;
                        ++n7;
                        ++n11;
                        continue;
                    }
                    if (n5 <= 0) {
                        ++n11;
                        continue;
                    }
                }
                while (n11 <= n12) {
                    n5 = this.block[this.zptr[n12] + n10 + 1] - c;
                    if (n5 == 0) {
                        n13 = this.zptr[n12];
                        this.zptr[n12] = this.zptr[n6];
                        this.zptr[n6] = n13;
                        --n6;
                        --n12;
                        continue;
                    }
                    if (n5 < 0) break;
                    --n12;
                }
                if (n11 > n12) break;
                n13 = this.zptr[n11];
                this.zptr[n11] = this.zptr[n12];
                this.zptr[n12] = n13;
                ++n11;
                --n12;
            }
            if (n6 < n7) {
                stackElem = stackElemArray[n4++];
                stackElem.ll = n8;
                stackElem.hh = n9;
                stackElem.dd = n10 + 1;
                continue;
            }
            n5 = n7 - n8 < n11 - n7 ? n7 - n8 : n11 - n7;
            this.vswap(n8, n11 - n5, n5);
            int n14 = n9 - n6 < n6 - n12 ? n9 - n6 : n6 - n12;
            this.vswap(n11, n9 - n14 + 1, n14);
            n5 = n8 + n11 - n7 - 1;
            n14 = n9 - (n6 - n12) + 1;
            stackElem = stackElemArray[n4++];
            stackElem.ll = n8;
            stackElem.hh = n5;
            stackElem.dd = n10;
            stackElem = stackElemArray[n4++];
            stackElem.ll = n5 + 1;
            stackElem.hh = n14 - 1;
            stackElem.dd = n10 + 1;
            stackElem = stackElemArray[n4++];
            stackElem.ll = n14;
            stackElem.hh = n9;
            stackElem.dd = n10;
        }
    }

    private void mainSort() {
        int n;
        for (n = 0; n < 20; ++n) {
            this.block[this.last + n + 2] = this.block[n % (this.last + 1) + 1];
        }
        this.quadrant = new int[this.last + 1 + 20];
        this.block[0] = this.block[this.last + 1];
        if (this.last < 4000) {
            for (n = 0; n <= this.last; ++n) {
                this.zptr[n] = n;
            }
            this.firstAttempt = false;
            this.workLimit = 0;
            this.workDone = 0;
            this.simpleSort(0, this.last, 0);
        } else {
            int n2;
            char c;
            int n3 = 0;
            boolean[] blArray = new boolean[256];
            int[] nArray = new int[65537];
            char c2 = this.block[0];
            for (n = 0; n <= this.last; ++n) {
                c = this.block[n + 1];
                int n4 = (c2 << 8) + c;
                nArray[n4] = nArray[n4] + 1;
                c2 = c;
            }
            for (n = 1; n <= 65536; ++n) {
                int n5 = n;
                nArray[n5] = nArray[n5] + nArray[n - 1];
            }
            c2 = this.block[1];
            n = 0;
            while (n < this.last) {
                c = this.block[n + 2];
                n2 = (c2 << 8) + c;
                c2 = c;
                int n6 = n2;
                nArray[n6] = nArray[n6] - 1;
                this.zptr[nArray[n2]] = n++;
            }
            int n7 = n2 = (this.block[this.last + 1] << 8) + this.block[1];
            nArray[n7] = nArray[n7] - 1;
            this.zptr[nArray[n2]] = this.last;
            int[] nArray2 = new int[256];
            for (n = 0; n <= 255; ++n) {
                nArray2[n] = n;
            }
            int n8 = 364;
            do {
                for (n = n8 /= 3; n <= 255; ++n) {
                    int n9 = nArray2[n];
                    n2 = n;
                    while (nArray[nArray2[n2 - n8] + 1 << 8] - nArray[nArray2[n2 - n8] << 8] > nArray[n9 + 1 << 8] - nArray[n9 << 8]) {
                        nArray2[n2] = nArray2[n2 - n8];
                        if ((n2 -= n8) > n8 - 1) continue;
                    }
                    nArray2[n2] = n9;
                }
            } while (n8 != 1);
            for (n = 0; n <= 255; ++n) {
                int n10 = nArray2[n];
                for (n2 = 0; n2 <= 255; ++n2) {
                    int n11 = (n10 << 8) + n2;
                    if ((nArray[n11] & 0x200000) == 0x200000) continue;
                    n8 = (nArray[n11 + 1] & 0xFFDFFFFF) - 1;
                    int n12 = nArray[n11] & 0xFFDFFFFF;
                    if (n8 > n12) {
                        this.qSort3(n12, n8, 2);
                        n3 += n8 - n12 + 1;
                        if (this.workDone > this.workLimit && this.firstAttempt) {
                            return;
                        }
                    }
                    int n13 = n11;
                    nArray[n13] = nArray[n13] | 0x200000;
                }
                blArray[n10] = true;
                if (n < 255) {
                    int n14 = nArray[n10 << 8] & 0xFFDFFFFF;
                    n8 = (nArray[n10 + 1 << 8] & 0xFFDFFFFF) - n14;
                    int n15 = 0;
                    while (n8 >> n15 > 65534) {
                        ++n15;
                    }
                    for (n2 = 0; n2 < n8; ++n2) {
                        int n16;
                        int n17 = this.zptr[n14 + n2];
                        this.quadrant[n17] = n16 = n2 >> n15;
                        if (n17 >= 20) continue;
                        this.quadrant[n17 + this.last + 1] = n16;
                    }
                    if (!$assertionsDisabled && n8 - 1 >> n15 > 65535) {
                        throw new AssertionError();
                    }
                }
                int[] nArray3 = new int[256];
                for (n2 = 0; n2 <= 255; ++n2) {
                    nArray3[n2] = nArray[(n2 << 8) + n10] & 0xFFDFFFFF;
                }
                for (n2 = nArray[n10 << 8] & 0xFFDFFFFF; n2 < (nArray[n10 + 1 << 8] & 0xFFDFFFFF); ++n2) {
                    c2 = this.block[this.zptr[n2]];
                    if (blArray[c2]) continue;
                    this.zptr[nArray3[c2]] = this.zptr[n2] == 0 ? this.last : this.zptr[n2] - 1;
                    char c3 = c2;
                    nArray3[c3] = nArray3[c3] + 1;
                }
                for (n2 = 0; n2 <= 255; ++n2) {
                    int n18 = (n2 << 8) + n10;
                    nArray[n18] = nArray[n18] | 0x200000;
                }
            }
        }
    }

    private void randomiseBlock() {
        int n;
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < 256; ++n) {
            this.inUse[n] = false;
        }
        for (n = 0; n <= this.last; ++n) {
            if (n2 == 0) {
                n2 = (char)rNums[n3];
                if (++n3 == 512) {
                    n3 = 0;
                }
            }
            int n4 = n + 1;
            this.block[n4] = (char)(this.block[n4] ^ (--n2 == 1 ? (char)'\u0001' : '\u0000'));
            int n5 = n + 1;
            this.block[n5] = (char)(this.block[n5] & 0xFF);
            this.inUse[this.block[n + 1]] = true;
        }
    }

    private void doReversibleTransformation() {
        this.workLimit = this.workFactor * this.last;
        this.workDone = 0;
        this.blockRandomised = false;
        this.firstAttempt = true;
        this.mainSort();
        if (this.workDone > this.workLimit && this.firstAttempt) {
            this.randomiseBlock();
            this.workDone = 0;
            this.workLimit = 0;
            this.blockRandomised = true;
            this.firstAttempt = false;
            this.mainSort();
        }
        this.origPtr = -1;
        for (int i = 0; i <= this.last; ++i) {
            if (this.zptr[i] != 0) continue;
            this.origPtr = i;
            break;
        }
        if (!$assertionsDisabled && this.origPtr == -1) {
            throw new AssertionError();
        }
    }

    private boolean fullGtU(int n, int n2) {
        char[] cArray = this.block;
        char c = cArray[n + 1];
        char c2 = cArray[n2 + 1];
        if (c != c2) {
            return c > c2;
        }
        if ((c = cArray[++n + 1]) != (c2 = cArray[++n2 + 1])) {
            return c > c2;
        }
        if ((c = cArray[++n + 1]) != (c2 = cArray[++n2 + 1])) {
            return c > c2;
        }
        if ((c = cArray[++n + 1]) != (c2 = cArray[++n2 + 1])) {
            return c > c2;
        }
        if ((c = cArray[++n + 1]) != (c2 = cArray[++n2 + 1])) {
            return c > c2;
        }
        if ((c = cArray[++n + 1]) != (c2 = cArray[++n2 + 1])) {
            return c > c2;
        }
        ++n;
        ++n2;
        int n3 = this.last + 1;
        int[] nArray = this.quadrant;
        do {
            if ((c = cArray[n + 1]) != (c2 = cArray[n2 + 1])) {
                return c > c2;
            }
            int n4 = nArray[n];
            int n5 = nArray[n2];
            if (n4 != n5) {
                return n4 > n5;
            }
            if ((c = cArray[++n + 1]) != (c2 = cArray[++n2 + 1])) {
                return c > c2;
            }
            n4 = nArray[n];
            n5 = nArray[n2];
            if (n4 != n5) {
                return n4 > n5;
            }
            if ((c = cArray[++n + 1]) != (c2 = cArray[++n2 + 1])) {
                return c > c2;
            }
            n4 = nArray[n];
            n5 = nArray[n2];
            if (n4 != n5) {
                return n4 > n5;
            }
            if ((c = cArray[++n + 1]) != (c2 = cArray[++n2 + 1])) {
                return c > c2;
            }
            n4 = nArray[n];
            n5 = nArray[n2];
            if (n4 != n5) {
                return n4 > n5;
            }
            ++n2;
            if (++n > this.last) {
                n -= this.last;
                --n;
            }
            if (n2 > this.last) {
                n2 -= this.last;
                --n2;
            }
            ++this.workDone;
        } while ((n3 -= 4) >= 0);
        return false;
    }

    private void allocateCompressStructures() {
        int n = 100000 * this.blockSize100k;
        this.block = new char[n + 1 + 20];
        this.zptr = new int[n];
        this.szptr = new short[2 * n];
    }

    private void generateMTFValues() {
        int n;
        char[] cArray = new char[256];
        this.makeMaps();
        int n2 = this.nInUse + 1;
        for (n = 0; n <= n2; ++n) {
            this.mtfFreq[n] = 0;
        }
        int n3 = 0;
        int n4 = 0;
        for (n = 0; n < this.nInUse; ++n) {
            cArray[n] = (char)n;
        }
        for (n = 0; n <= this.last; ++n) {
            char c = this.unseqToSeq[this.block[this.zptr[n]]];
            int n5 = 0;
            char c2 = cArray[n5];
            while (c != c2) {
                char c3 = c2;
                c2 = cArray[++n5];
                cArray[n5] = c3;
            }
            cArray[0] = c2;
            if (n5 == 0) {
                ++n4;
                continue;
            }
            if (n4 > 0) {
                --n4;
                while (true) {
                    if ((n4 & 1) == 0) {
                        this.szptr[n3++] = 0;
                        this.mtfFreq[0] = this.mtfFreq[0] + 1;
                    } else {
                        this.szptr[n3++] = 1;
                        this.mtfFreq[1] = this.mtfFreq[1] + 1;
                    }
                    if (n4 < 2) break;
                    n4 = (n4 - 2) / 2;
                }
                n4 = 0;
            }
            this.szptr[n3++] = (short)(n5 + 1);
            int n6 = n5 + 1;
            this.mtfFreq[n6] = this.mtfFreq[n6] + 1;
        }
        if (n4 > 0) {
            --n4;
            while (true) {
                if ((n4 & 1) == 0) {
                    this.szptr[n3++] = 0;
                    this.mtfFreq[0] = this.mtfFreq[0] + 1;
                } else {
                    this.szptr[n3++] = 1;
                    this.mtfFreq[1] = this.mtfFreq[1] + 1;
                }
                if (n4 < 2) break;
                n4 = (n4 - 2) / 2;
            }
        }
        this.szptr[n3++] = (short)n2;
        int n7 = n2;
        this.mtfFreq[n7] = this.mtfFreq[n7] + 1;
        this.nMTF = n3;
    }

    static {
        $assertionsDisabled = !CBZip2OutputStream.class.desiredAssertionStatus();
    }

    private static class StackElem {
        int ll;
        int hh;
        int dd;

        private StackElem() {
        }
    }
}

