/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std.span;

import java.util.Map;
import multivalent.Browser;
import multivalent.Context;
import multivalent.ESISNode;
import multivalent.INode;
import multivalent.Layer;
import multivalent.SemanticEvent;
import multivalent.Span;
import phelps.lang.Floats;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PointSpan
extends Span {
    public static final String MSG_CHANGE = "changePoints";
    public static final String MSG_EDIT = "editPoints";
    public static final String ATTR_POINTS = "points";
    public static final String ATTR_POINT = "point";
    static String[] choices_ = null;
    static String oldchoices_ = null;
    static float defaultPoints_ = 12.0f;
    float points_ = defaultPoints_;

    public void setPoints(int n) {
        this.points_ = n;
    }

    @Override
    public boolean appearance(Context context, boolean bl) {
        context.size = this.points_;
        return false;
    }

    @Override
    public boolean semanticEventBefore(SemanticEvent semanticEvent, String string) {
        if (super.semanticEventBefore(semanticEvent, string)) {
            return true;
        }
        if (this == semanticEvent.getIn() && "createWidget/DOCPOPUP" == string && this.isEditable()) {
            INode iNode = (INode)semanticEvent.getOut();
            Browser browser = this.getBrowser();
            String string2 = this.getAttr(ATTR_POINTS, "5 7 9 10 12 14 18 24 36 48 72");
            if (!string2.equals(oldchoices_)) {
                choices_ = string2.split("\\s+");
                oldchoices_ = string2;
            }
            for (String string3 : choices_) {
                this.createUI("button", new StringBuffer().append(string3).append(" points").toString(), new SemanticEvent(browser, MSG_CHANGE, string3, this, null), iNode, "EDIT", false);
            }
        }
        return false;
    }

    @Override
    public boolean semanticEventAfter(SemanticEvent semanticEvent, String string) {
        if (this == semanticEvent.getIn()) {
            if (MSG_CHANGE == string) {
                Object object = semanticEvent.getArg();
                int n = -1;
                if (object != null) {
                    if (object instanceof Integer) {
                        n = (Integer)object;
                    } else if (object instanceof String) {
                        try {
                            n = Integer.parseInt((String)object);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
                if (n > 0) {
                    this.points_ = defaultPoints_ = (float)n;
                    this.markDirty();
                    this.getBrowser().repaint();
                }
            } else if (MSG_EDIT == string) {
                // empty if block
            }
        }
        return super.semanticEventAfter(semanticEvent, string);
    }

    @Override
    public ESISNode save() {
        this.putAttr(ATTR_POINT, String.valueOf(this.points_));
        return super.save();
    }

    @Override
    public void restore(ESISNode eSISNode, Map<String, Object> map, Layer layer) {
        super.restore(eSISNode, map, layer);
        this.points_ = Floats.parseFloat(this.getAttr(ATTR_POINT), 12.0f);
    }
}

