/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std.adaptor.pdf;

import com.pt.imageio.plugins.Fax;
import com.pt.imageio.plugins.JPEG;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import multivalent.Meta;
import multivalent.std.adaptor.pdf.COS;
import multivalent.std.adaptor.pdf.COSSource;
import multivalent.std.adaptor.pdf.ColorSpaces;
import multivalent.std.adaptor.pdf.Dict;
import multivalent.std.adaptor.pdf.InputStreamComposite;
import multivalent.std.adaptor.pdf.PDFReader;
import phelps.awt.color.ColorSpaceCMYK;
import phelps.awt.color.ColorSpaceLab;
import phelps.awt.color.ColorSpaceYCCK;
import phelps.awt.image.Rasters;
import phelps.io.InputStreams;

public class Images {
    private static final boolean DEBUG = false;
    private static BufferedImage jpeg2000;
    private static BufferedImage jbig2;
    static final /* synthetic */ boolean $assertionsDisabled;

    private Images() {
    }

    public static BufferedImage createImage(Dict dict, InputStream inputStream, AffineTransform affineTransform, Color color, PDFReader pDFReader) throws IOException {
        AffineTransform affineTransform2;
        double d;
        if (!$assertionsDisabled && (dict == null || inputStream == null || affineTransform == null || !"Image".equals(dict.get("Subtype")) && dict.get("Subtype") != null)) {
            throw new AssertionError();
        }
        int n = pDFReader.getObjInt(dict.get("Width"));
        int n2 = pDFReader.getObjInt(dict.get("Height"));
        int n3 = 1;
        double d2 = Math.abs(affineTransform.getScaleX()) / (double)n;
        double d3 = Math.abs(affineTransform.getScaleY()) / (double)n2;
        String string = Images.getFilter(dict, pDFReader);
        if (!affineTransform.isIdentity() && d2 != 0.0 && d3 != 0.0 && n * n2 > 0x1000000 && Math.abs(d2 - d3) <= 0.01) {
            for (int i = 32; i >= 2; i /= 2) {
                float f = 1.0f / (float)(i * 2);
                if (!(d2 <= (double)f) || !(d3 <= (double)f)) continue;
                n3 = i;
                break;
            }
        }
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = "DCTDecode".equals(string) ? Images.createJPEG(dict, inputStream, pDFReader) : ("JPXDecode".equals(string) ? Images.createJPEG2000(dict, inputStream) : ("CCITTFaxDecode".equals(string) ? Images.createFAX(dict, inputStream, n3, color, pDFReader) : ("JBIG2Decode".equals(string) ? Images.createJBIG2(dict, inputStream) : Images.createRaw(dict, n, n2, inputStream, n3, color, pDFReader))));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (bufferedImage == null || bufferedImage == jpeg2000 || bufferedImage == jbig2) {
            return bufferedImage;
        }
        if (affineTransform.isIdentity()) {
            return bufferedImage;
        }
        n = bufferedImage.getWidth();
        n2 = bufferedImage.getHeight();
        if (affineTransform.getScaleX() != 0.0) {
            // empty if block
        }
        if (affineTransform.getScaleX() != 0.0) {
            d = affineTransform.getScaleX();
            double d4 = affineTransform.getScaleY();
            affineTransform2 = new AffineTransform(d / (double)n, affineTransform.getShearY(), affineTransform.getShearX(), -(d4 / (double)n2 + (d4 < 0.0 ? -1.0 : 1.0) / (double)n2), 0.0, 0.0);
            affineTransform2 = new AffineTransform(d / (double)n, 0.0, 0.0, -(d4 + (d4 < 0.0 ? -1.0 : 1.0)) / (double)n2, 0.0, 0.0);
            if (affineTransform2.getScaleX() < 0.0) {
                affineTransform2.translate(-n, 0.0);
            }
            if (affineTransform2.getScaleY() < 0.0) {
                affineTransform2.translate(0.0, -n2);
            }
        } else {
            d = affineTransform.getShearX();
            double d5 = affineTransform.getShearY();
            affineTransform2 = new AffineTransform(0.0, d5 / (double)n, -d / (double)n2, 0.0, 0.0, 0.0);
            if (affineTransform2.getShearX() < 0.0) {
                affineTransform2.translate(0.0, -n2);
            }
            if (affineTransform2.getShearY() < 0.0) {
                affineTransform2.translate(-n, 0.0);
            }
        }
        try {
            boolean bl = false;
            if (bl) {
                AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform2, 1);
                bufferedImage = affineTransformOp.filter(bufferedImage, null);
            } else if ("CCITTFaxDecode".equals(Images.getFilter(dict, pDFReader))) {
                bufferedImage = Fax.scale(bufferedImage, affineTransform2);
            } else if (Boolean.TRUE == pDFReader.getObject(dict.get("ImageMask")) && Color.BLACK.equals(color) && n * n2 < 5120) {
                bufferedImage = Fax.scale(bufferedImage, affineTransform2);
            } else {
                AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform2, 2);
                bufferedImage = affineTransformOp.filter(bufferedImage, null);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(exception);
            System.err.println(dict.get("Name") + " " + Images.getFilter(dict, pDFReader) + " " + n + "X" + n2 + ", w/" + affineTransform + " => " + affineTransform2);
        }
        return bufferedImage;
    }

    public static BufferedImage createInline(InputStreamComposite inputStreamComposite, Dict dict, AffineTransform affineTransform, Color color, PDFReader pDFReader) throws IOException {
        Dict dict2 = pDFReader.readInlineImage(inputStreamComposite);
        InputStreamComposite inputStreamComposite2 = pDFReader.getInputStream(dict2);
        Object object = dict2.get("ColorSpace");
        if (dict != null && dict.get(object) != null) {
            dict2.put("ColorSpace", dict.get(object));
        }
        BufferedImage bufferedImage = Images.createImage(dict2, inputStreamComposite2, affineTransform, color, pDFReader);
        ((InputStream)inputStreamComposite2).close();
        if (!$assertionsDisabled && bufferedImage == null) {
            throw new AssertionError((Object)("bad INLINE IMG " + dict2));
        }
        return bufferedImage;
    }

    public static String getFilter(Dict dict, COSSource cOSSource) throws IOException {
        String string;
        Object object = dict.get("Filter");
        if (cOSSource != null) {
            object = cOSSource.getObject(object);
        }
        if (object == null || COS.OBJECT_NULL == object) {
            string = null;
        } else if (COS.CLASS_NAME == object.getClass()) {
            string = (String)object;
        } else {
            if (!$assertionsDisabled && COS.CLASS_ARRAY != object.getClass()) {
                throw new AssertionError();
            }
            Object[] objectArray = (Object[])object;
            Object object2 = objectArray.length > 0 ? objectArray[objectArray.length - 1] : null;
            string = (String)(cOSSource != null ? cOSSource.getObject(object2) : object2);
        }
        if ("DCT".equals(string)) {
            string = "DCTDecode";
        } else if ("CCF".equals(string)) {
            string = "CCITTFaxDecode";
        }
        if (!("DCTDecode".equals(string) || "CCITTFaxDecode".equals(string) || "JBIG2Decode".equals(string) || "JPXDecode".equals(string))) {
            string = null;
        }
        return string;
    }

    public static double[] getDecode(Dict dict, COSSource cOSSource) throws IOException {
        double[] dArray = null;
        Object object = cOSSource.getObject(dict.get("Decode"));
        if (object != null && COS.CLASS_ARRAY == object.getClass()) {
            Object[] objectArray = (Object[])object;
            dArray = new double[objectArray.length];
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                dArray[i] = ((Number)objectArray[i]).doubleValue();
            }
        }
        return dArray;
    }

    public static Dict getDecodeParms(Dict dict, PDFReader pDFReader) throws IOException {
        Object object = pDFReader.getObject(dict.get("DecodeParms"));
        Object object2 = object == null || COS.OBJECT_NULL == object ? COS.OBJECT_NULL : (COS.CLASS_DICTIONARY == object.getClass() ? object : pDFReader.getObject(((Object[])object)[((Object[])object).length - 1]));
        return object2 != COS.OBJECT_NULL ? (Dict)object2 : null;
    }

    public static String getSuffix(String string) {
        return "DCTDecode".equals(string) ? "jpg" : ("JPXDecode".equals(string) ? "jp2" : ("CCITTFaxDecode".equals(string) ? "fax" : ("JBIG2Decode".equals(string) ? "jbig2" : "raw")));
    }

    static BufferedImage createJPEG(Dict dict, InputStream inputStream, PDFReader pDFReader) throws IOException {
        Object object;
        Object object2;
        if (!($assertionsDisabled || dict != null && inputStream != null)) {
            throw new AssertionError();
        }
        ColorSpace colorSpace = pDFReader.getColorSpace(dict.get("ColorSpace"), null, null);
        int n = 4;
        int n2 = colorSpace.getNumComponents();
        if (n2 == 4) {
            object2 = dict.get("Length");
            object = InputStreams.toByteArray(inputStream, object2 != null ? (long)pDFReader.getObjInt(object2) : 10240L);
            n = JPEG.getTransform((byte[])object);
            inputStream = new ByteArrayInputStream((byte[])object);
        }
        object = ImageIO.getImageReadersByFormatName("JPEG").next();
        ImageIO.setUseCache(false);
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(inputStream);
        ((ImageReader)object).setInput(imageInputStream, true);
        try {
            if (n2 == 4 || colorSpace instanceof ColorSpaceLab) {
                ImageReadParam imageReadParam = ((ImageReader)object).getDefaultReadParam();
                colorSpace = 12 == n ? ColorSpaceCMYK.getInstance() : (13 == n ? ColorSpaceYCCK.getInstance() : colorSpace);
                Raster raster = ((ImageReader)object).readRaster(0, imageReadParam);
                raster = Rasters.toRGB(raster, colorSpace);
                ComponentColorModel componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1000), false, true, 1, 0);
                object2 = new BufferedImage(componentColorModel, (WritableRaster)raster, true, null);
            } else {
                object2 = ((ImageReader)object).read(0, null);
            }
        }
        catch (IOException iOException) {
            object2 = null;
            System.err.println("Couldn't read JPEG: " + iOException);
        }
        ((ImageReader)object).dispose();
        imageInputStream.close();
        return object2;
    }

    static BufferedImage createJPEG2000(Dict dict, InputStream inputStream) throws IOException {
        BufferedImage bufferedImage;
        if (!$assertionsDisabled && inputStream == null) {
            throw new AssertionError();
        }
        if (jpeg2000 != null) {
            return jpeg2000;
        }
        Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName("JPEG2000");
        if (iterator.hasNext()) {
            ImageReader imageReader = iterator.next();
            ImageIO.setUseCache(false);
            ImageInputStream imageInputStream = ImageIO.createImageInputStream(inputStream);
            imageReader.setInput(imageInputStream, true);
            try {
                bufferedImage = imageReader.read(0);
            }
            catch (IOException iOException) {
                bufferedImage = null;
            }
            imageReader.dispose();
            imageInputStream.close();
        } else {
            System.err.println("No decoder for JPEG2000 -- install ImageIO from Sun or Apple");
            int n = 20;
            int n2 = 20;
            bufferedImage = jpeg2000 = new BufferedImage(n, n2, 2);
            Graphics graphics = jpeg2000.getGraphics();
            graphics.setColor(Color.BLUE);
            graphics.fillRect(0, 0, n, n2 / 2);
            graphics.setColor(Color.GREEN);
            graphics.fillRect(0, n2 / 2, n, n2 / 2);
            graphics.dispose();
        }
        return bufferedImage;
    }

    static BufferedImage createFAX(Dict dict, InputStream inputStream, int n, Color color, PDFReader pDFReader) throws IOException {
        IndexColorModel indexColorModel;
        int n2;
        int n3;
        Object object;
        if (!($assertionsDisabled || dict != null && inputStream != null)) {
            throw new AssertionError();
        }
        Dict dict2 = Images.getDecodeParms(dict, pDFReader);
        if (dict2 == null) {
            dict2 = new Dict(3);
        }
        int n4 = (object = dict2.get("K")) != null ? pDFReader.getObjInt(object) : 0;
        object = dict2.get("Columns");
        int n5 = n3 = object != null ? pDFReader.getObjInt(object) : 1728;
        if (!$assertionsDisabled && n3 < 1) {
            throw new AssertionError(n3);
        }
        int n6 = pDFReader.getObjInt(dict.get("Width"));
        if (n3 != n6 && (n2 = n6 % 8) != 0) {
            n6 += 8 - n2;
        }
        n2 = pDFReader.getObjInt(dict.get("Height"));
        object = dict2.get("Rows");
        int n7 = object != null ? pDFReader.getObjInt(object) : -n2;
        boolean bl = Boolean.TRUE == pDFReader.getObject(dict2.get("EndOfLine"));
        boolean bl2 = Boolean.FALSE != pDFReader.getObject(dict2.get("EndOfBlock"));
        boolean bl3 = Boolean.TRUE == pDFReader.getObject(dict2.get("EncodedByteAlign"));
        boolean bl4 = Boolean.TRUE == pDFReader.getObject(dict2.get("BlackIs1"));
        object = dict2.get("DamagedRowsBeforeError");
        int n8 = object != null ? pDFReader.getObjInt(object) : 0;
        double[] dArray = Images.getDecode(dict, pDFReader);
        boolean bl5 = dArray != null && dArray[0] == 1.0 && dArray[1] == 0.0;
        Object object2 = pDFReader.getObject(dict.get("ColorSpace"));
        if (object2 != null && COS.CLASS_ARRAY == object2.getClass() && ("Indexed".equals(((Object[])object2)[0]) || "I".equals(((Object[])object2)[0])) && (indexColorModel = ColorSpaces.createIndexColorModel(object2, 1, pDFReader)).getRGB(0) != Color.BLACK.getRGB() && indexColorModel.getRGB(1) == Color.BLACK.getRGB()) {
            bl5 = true;
        }
        byte by = (byte)(bl4 ^ bl5 ? 1 : 0);
        BufferedImage bufferedImage = Fax.decode(n4, n6, n3, n7, n, bl, bl2, bl3, by, n8, inputStream);
        if (Boolean.TRUE == pDFReader.getObject(dict.get("ImageMask")) && color.getRed() > 8 && color.getBlue() > 8 && color.getBlue() > 8) {
            IndexColorModel indexColorModel2 = new IndexColorModel(8, 2, new int[]{0, color.getRGB()}, 0, true, 0, 0);
            bufferedImage = new BufferedImage(indexColorModel2, bufferedImage.getRaster(), false, new Hashtable());
        }
        return bufferedImage;
    }

    static BufferedImage createJBIG2(Dict dict, InputStream inputStream) throws IOException {
        if (jbig2 == null) {
            System.err.println("No decoder for JBIG2.");
            int n = 20;
            int n2 = 20;
            jbig2 = new BufferedImage(n, n2, 2);
            Graphics graphics = jbig2.getGraphics();
            graphics.setColor(Color.WHITE);
            graphics.fillRect(0, 0, n, n2);
            graphics.setColor(Color.BLACK);
            int n3 = 5;
            for (int i = 0; i < n2; i += n3) {
                for (int j = 0; j < n; j += n3) {
                    graphics.fillRect(j + 1, i + 1, n3 / 2, n3 / 2);
                }
            }
            graphics.dispose();
        }
        return jbig2;
    }

    static BufferedImage createRaw(Dict dict, int n, int n2, InputStream inputStream, int n3, Color color, PDFReader pDFReader) throws IOException {
        double[] dArray;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        Object object;
        byte[] byArray;
        int n9;
        if (!($assertionsDisabled || dict != null && n > 0 && n2 > 0 && inputStream != null && color != null && pDFReader != null)) {
            throw new AssertionError();
        }
        Boolean bl = (Boolean)pDFReader.getObject(pDFReader.getObject(dict.get("ImageMask")));
        int n10 = bl == Boolean.TRUE ? 1 : pDFReader.getObjInt(dict.get("BitsPerComponent"));
        ColorModel colorModel = Images.createRawColorModel(pDFReader.getObject(dict.get("ColorSpace")), bl, n10, color, pDFReader);
        int n11 = colorModel instanceof IndexColorModel ? 1 : colorModel.getNumComponents();
        int n12 = (n * n11 * n10 + 7) / 8;
        if (n3 > 1 && n10 == 8) {
            n9 = n / n3;
            int n13 = n2 / n3;
            byArray = new byte[n9 * n13 * n11];
            object = new byte[n12];
            n8 = 0;
            n7 = n3 * n11;
            for (n6 = 0; n6 < n13; ++n6) {
                InputStreams.readFully(inputStream, (byte[])object);
                n5 = 0;
                while (n5 + n7 <= n12) {
                    n4 = 0;
                    while (n4 < n11) {
                        byArray[n8 + n4] = object[n5 + n4];
                        ++n4;
                        ++n8;
                    }
                    n5 += n7;
                }
                InputStreams.skipFully(inputStream, n12 * (n3 - 1));
            }
            n = n9;
            n2 = n13;
            n12 = n9 * n11;
        } else {
            byArray = InputStreams.toByteArray(inputStream, n * n2 * n11);
        }
        n9 = n12 * n2;
        if (byArray.length < n9) {
            n2 = byArray.length / n12;
        }
        if ((dArray = Images.getDecode(dict, pDFReader)) != null) {
            boolean bl2 = true;
            n6 = 1;
            n7 = dArray.length;
            for (n8 = 0; n8 < n7; n8 += 2) {
                if (dArray[n8] != 0.0 || dArray[n8 + 1] != 1.0) {
                    bl2 = false;
                }
                if (dArray[n8] == 1.0 && dArray[n8 + 1] == 0.0) continue;
                n6 = 0;
            }
            if (n6 != 0) {
                n8 = 0;
                n7 = byArray.length;
                while (n8 < n7) {
                    int n14 = n8++;
                    byArray[n14] = (byte)(byArray[n14] ^ 0xFF);
                }
            } else if (!bl2) {
                Meta.unsupported("Decode matrix: " + Arrays.asList((Object[])pDFReader.getObject(dict.get("Decode"))) + ", len=" + dArray.length);
            }
        }
        if (n10 == 8 && colorModel.getColorSpace() instanceof ColorSpaceCMYK) {
            object = new byte[n * n2 * 3];
            n6 = 0;
            n8 = Math.min(n * n2 * 4, byArray.length);
            n7 = 0;
            while (n6 < n8) {
                n5 = byArray[n6 + 3] & 0xFF;
                object[n7] = (byte)(255 - Math.min(255, (byArray[n6] & 0xFF) + n5));
                object[n7 + 1] = (byte)(255 - Math.min(255, (byArray[n6 + 1] & 0xFF) + n5));
                object[n7 + 2] = (byte)(255 - Math.min(255, (byArray[n6 + 2] & 0xFF) + n5));
                n6 += 4;
                n7 += 3;
            }
            byArray = object;
            colorModel = new ComponentColorModel(ColorSpace.getInstance(1000), false, true, 1, 0);
            n11 = 3;
        }
        if (Boolean.TRUE == bl && Color.BLACK.equals(color) && n * n2 < 5120) {
            if (!$assertionsDisabled && n11 != 1) {
                throw new AssertionError(n11);
            }
            byte[] byArray2 = new byte[n * n2];
            n8 = 0;
            n7 = 0;
            n5 = 0;
            while (n8 < n2) {
                n4 = 0;
                int n15 = 0;
                for (int i = 0; i < n; ++i) {
                    if (n4 <= 0) {
                        n15 = byArray[n7++] & 0xFF;
                        n4 = 8;
                    }
                    byArray2[n5 + i] = (n15 & 0x80) == 0 ? (byte)1 : 0;
                    n15 <<= 1;
                    --n4;
                }
                ++n8;
                n5 += n;
            }
            byArray = byArray2;
            n10 = 8;
            bl = Boolean.FALSE;
            colorModel = Fax.CM_BLACKWHITE;
            object = Raster.createInterleavedRaster(new DataBufferByte(byArray, byArray.length), n, n2, n, 1, new int[]{0}, null);
        } else {
            object = Images.createRawRaster(byArray, n, n2, n10, n11);
        }
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = new BufferedImage(colorModel, (WritableRaster)object, false, new Hashtable());
        }
        catch (Exception exception) {
            System.err.println(exception);
            System.out.println("color model = " + colorModel);
            SampleModel sampleModel = ((Raster)object).getSampleModel();
            System.out.println("sample model = " + sampleModel);
            System.out.println("sample model instance of ComponentSampleModel " + (sampleModel instanceof ComponentSampleModel));
            System.out.println("num bands = " + sampleModel.getNumBands() + " ==? " + colorModel.getNumComponents() + " cm num comp");
            int[] nArray = colorModel.getComponentSize();
            for (n4 = 0; n4 < nArray.length; ++n4) {
                System.out.println("  " + sampleModel.getSampleSize(n4) + " >=? " + nArray[n4]);
            }
            System.out.println(((Raster)object).getTransferType() + " ==? " + sampleModel.getTransferType());
        }
        return bufferedImage;
    }

    private static ColorModel createRawColorModel(Object object, Boolean bl, int n, Color color, PDFReader pDFReader) throws IOException {
        ColorModel colorModel;
        Object object2 = pDFReader.getObject(object);
        ColorSpace colorSpace = pDFReader.getColorSpace(object, null, null);
        if (!$assertionsDisabled && colorSpace == null && Boolean.TRUE != bl) {
            throw new AssertionError();
        }
        if (Boolean.TRUE == bl) {
            if (!$assertionsDisabled && n != 1) {
                throw new AssertionError();
            }
            colorModel = new IndexColorModel(1, 2, new int[]{color.getRGB(), 0}, 0, true, 1, 0);
        } else if (COS.CLASS_ARRAY == object2.getClass() && ("Indexed".equals(((Object[])object2)[0]) || "I".equals(((Object[])object2)[0]))) {
            colorModel = ColorSpaces.createIndexColorModel(object2, n, pDFReader);
        } else if (colorSpace.getNumComponents() == 1 && n < 8) {
            colorModel = n == 1 ? new IndexColorModel(1, 2, new int[]{0, 0xFFFFFF}, 0, false, -1, 0) : (n == 2 ? new IndexColorModel(2, 4, new int[]{0, 0x404040, 0xC0C0C0, 0xFFFFFF}, 0, false, -1, 0) : new IndexColorModel(4, 16, new int[]{0, 0x111111, 0x222222, 0x333333, 0x444444, 0x555555, 0x666666, 0x777777, 0x888888, 0x999999, 0xAAAAAA, 0xBBBBBB, 0xCCCCCC, 0xDDDDDD, 0xEEEEEE, 0xFFFFFF}, 0, false, -1, 0));
        } else if (n == 8 || n == 4) {
            colorModel = new ComponentColorModel(colorSpace, false, true, 1, 0);
        } else {
            int n2 = colorSpace.getNumComponents();
            if (!$assertionsDisabled && (n2 != 3 && n2 != 4 || n != 2 && n != 1)) {
                throw new AssertionError((Object)("bpc=" + n));
            }
            int n3 = 1 << n;
            byte[] byArray = new byte[(1 << n * n2) * n2];
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = 0.0f;
            float f5 = 1.0f / (float)n3;
            float[] fArray = new float[4];
            int n4 = 0;
            int n5 = 0;
            while (n5 < n3) {
                fArray[0] = f;
                int n6 = 0;
                while (n6 < n3) {
                    fArray[1] = f2;
                    int n7 = 0;
                    while (n7 < n3) {
                        fArray[2] = f3;
                        int n8 = 0;
                        while (n8 < n3) {
                            fArray[3] = f4;
                            Color color2 = new Color(colorSpace, fArray, 0.0f);
                            byArray[n4++] = (byte)color2.getRed();
                            byArray[n4++] = (byte)color2.getGreen();
                            byArray[n4++] = (byte)color2.getBlue();
                            if (n2 == 3) break;
                            ++n8;
                            f4 += f5;
                        }
                        ++n7;
                        f3 += f5;
                        f4 = 0.0f;
                    }
                    ++n6;
                    f2 += f5;
                    f3 = 0.0f;
                    f4 = 0.0f;
                }
                ++n5;
                f += f5;
                f2 = 0.0f;
                f3 = 0.0f;
                f4 = 0.0f;
            }
            if (!$assertionsDisabled && n4 != byArray.length) {
                throw new AssertionError((Object)(n4 + " vs " + byArray.length));
            }
            colorModel = new IndexColorModel(n, byArray.length / n2, byArray, 0, false);
        }
        return colorModel;
    }

    private static WritableRaster createRawRaster(byte[] byArray, int n, int n2, int n3, int n4) {
        WritableRaster writableRaster;
        int n5;
        int[] nArray = new int[n4];
        for (n5 = 0; n5 < n4; ++n5) {
            nArray[n5] = n5;
        }
        if (n3 == 8 || n3 == 2 && n4 == 4) {
            writableRaster = Raster.createInterleavedRaster(new DataBufferByte(byArray, byArray.length), n, n2, n * n4, n4, nArray, null);
        } else if (n4 == 1) {
            if (!$assertionsDisabled && n3 != 4 && n3 != 2 && n3 != 1) {
                throw new AssertionError();
            }
            writableRaster = Raster.createPackedRaster(new DataBufferByte(byArray, byArray.length), n, n2, n3, null);
        } else if (n3 == 4 || n3 == 1 && n4 == 4) {
            n5 = n * n4;
            boolean bl = (n5 & 1) == 1;
            byte[] byArray2 = new byte[n5 * n2 + (bl ? 1 : 0)];
            int n6 = 0;
            int n7 = 0;
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n5; j += 2) {
                    byte by = byArray[n6++];
                    byArray2[n7++] = (byte)(by & 0xF0);
                    byArray2[n7++] = (byte)(by << 4 & 0xF0);
                }
                if (!bl) continue;
                --n7;
            }
            writableRaster = Raster.createInterleavedRaster(new DataBufferByte(byArray2, byArray2.length), n, n2, n5, n4, nArray, null);
        } else if (n3 == 2) {
            byte[] byArray3 = new byte[n * n2];
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            int n12 = 0;
            int n13 = (n * n4 * n3 + 7) / 8;
            while (n10 < n2) {
                for (int i = 0; i < n; ++i) {
                    if (n8 < 6) {
                        n9 = n9 << 8 | byArray[n12++];
                        n8 += 8;
                    }
                    byArray3[n11++] = (byte)(n9 >> n8 - 6 & 0x3F);
                    n8 -= 6;
                }
                n12 = ++n10 * n13;
            }
            writableRaster = Raster.createInterleavedRaster(new DataBufferByte(byArray3, byArray3.length), n, n2, n * n4, n4, new int[]{0}, null);
            Meta.sampledata("2 bpc packed BYTE: " + byArray.length + " => " + byArray3.length);
        } else {
            if (!$assertionsDisabled && n3 != 1) {
                throw new AssertionError();
            }
            byte[] byArray4 = new byte[n * n2];
            int n14 = 0;
            int n15 = 0;
            int n16 = 0;
            int n17 = 0;
            int n18 = 0;
            int n19 = (n * n4 * n3 + 7) / 8;
            while (n16 < n2) {
                for (int i = 0; i < n; ++i) {
                    if (n14 < 3) {
                        n15 = n15 << 8 | byArray[n18++];
                        n14 += 8;
                    }
                    byArray4[n17++] = (byte)(n15 >> n14 - 3 & 7);
                    n14 -= 3;
                }
                n18 = ++n16 * n19;
            }
            writableRaster = Raster.createInterleavedRaster(new DataBufferByte(byArray4, byArray4.length), n, n2, n * n4, n4, new int[]{0}, null);
            Meta.sampledata("1 bit packed byte: " + byArray.length + " => " + byArray4.length);
        }
        return writableRaster;
    }

    static {
        $assertionsDisabled = !Images.class.desiredAssertionStatus();
        jpeg2000 = null;
        jbig2 = null;
    }
}

