/*
 * Decompiled with CFR 0.152.
 */
package multivalent.node;

import java.awt.AWTEvent;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Map;
import multivalent.Context;
import multivalent.INode;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IZoom
extends INode {
    public int Zoom = 200;

    public IZoom(String string, Map<String, Object> map, INode iNode) {
        super(string, map, iNode);
    }

    @Override
    public boolean formatNode(int n, int n2, Context context) {
        boolean bl = super.formatNode(n, n2, context);
        this.bbox.width = this.bbox.width * this.Zoom / 100;
        this.bbox.height = this.bbox.height * this.Zoom / 100;
        return bl;
    }

    @Override
    public void paintNode(Rectangle rectangle, Context context) {
        Graphics2D graphics2D = context.g;
        Rectangle rectangle2 = graphics2D.getClipBounds();
        double d = (double)this.Zoom / 100.0;
        graphics2D.scale(d, d);
        graphics2D.setClip(0, 0, this.bbox.width, this.bbox.height);
        System.out.println(new StringBuffer().append("scale by ").append((double)this.Zoom / 100.0).append(", clip ").append(rectangle2).append(" => ").append(graphics2D.getClipBounds()).toString());
        super.paintNode(rectangle, context);
        d = 1.0 / d;
        graphics2D.scale(d, d);
    }

    @Override
    public boolean eventNode(AWTEvent aWTEvent, Point point) {
        if (point != null) {
            point.x = point.x * 100 / this.Zoom;
            point.y = point.y * 100 / this.Zoom;
        }
        boolean bl = super.eventNode(aWTEvent, point);
        if (point != null) {
            point.x = point.x * this.Zoom / 100;
            point.y = point.y * this.Zoom / 100;
        }
        return bl;
    }
}

