/*
 * Decompiled with CFR 0.152.
 */
package multivalent;

import com.pt.io.Cache;
import com.pt.io.CacheFile;
import com.pt.net.MIME;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.imageio.ImageIO;
import multivalent.Browser;
import multivalent.CHashMap;
import phelps.io.Files;
import phelps.util.logging.FormatterShort;
import phelps.util.logging.HandlerStream;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Multivalent {
    public static final String COPYRIGHT = "Copyright (c) 1997 - 2005  T.A. Phelps";
    public static final String VERSION;
    public static final String MSG_EXIT = "EXIT";
    public static final String FILENAME_PREFERENCES = "Preferences.txt";
    private static final String PREF_HOMEDIR = "HOMEDIR";
    public static final String PREF_CACHEDIR = "CACHEDIR";
    public static final URI HOME_SITE;
    private static Multivalent instance_;
    private boolean fstandalone_ = false;
    private Level loglevel_ = Level.CONFIG;
    private CHashMap<String> defadaptor_;
    private CHashMap<String> adaptor_ = new CHashMap(100);
    private HashMap<String, String> defberemap_;
    private HashMap<String, String> beremap_ = new HashMap(100);
    private CHashMap<String> defpref_;
    private CHashMap<String> pref_ = new CHashMap(100);
    private List<Browser> browsers_ = new ArrayList<Browser>(5);
    private Cache cache_ = null;
    private Timer timer_ = null;
    static /* synthetic */ Class class$multivalent$Multivalent;
    static final /* synthetic */ boolean $assertionsDisabled;

    private Multivalent() {
    }

    public static Multivalent getInstance() {
        if (instance_ == null) {
            instance_ = new Multivalent();
            instance_.config();
        }
        return instance_;
    }

    private void config() {
        Object object;
        File file;
        String string = System.getProperty("user.home");
        String string2 = System.getProperty("user.name");
        String string3 = System.getProperty("java.io.tmpdir");
        String string4 = this.getPreference(PREF_CACHEDIR, null);
        if (string4 == null) {
            String string5 = string4 = string != null ? string : string3;
            if (string2 != null && !string4.endsWith(string2)) {
                string4 = new StringBuffer().append(string4).append(File.separatorChar).append(string2).toString();
            }
            string4 = new StringBuffer().append(string4).append(File.separatorChar).append(".Multivalent").toString();
        }
        if (!(file = new File(string4)).exists()) {
            file.mkdirs();
        }
        this.putPreference(PREF_HOMEDIR, string);
        for (String string6 : ImageIO.getReaderMIMETypes()) {
            object = string6.toLowerCase();
            if (this.adaptor_.get((String)object) != null) continue;
            this.adaptor_.put(string6, "RawImage");
        }
        for (String string6 : ImageIO.getReaderFormatNames()) {
            object = string6.toLowerCase();
            if (this.adaptor_.get((String)object) != null) continue;
            this.adaptor_.put((String)object, "RawImage");
        }
        if (this.adaptor_.get("jpeg2000") != null && this.adaptor_.get("jp2") == null) {
            this.adaptor_.put("jp2", "RawImage");
        }
        Object object2 = Logger.getLogger("");
        ((Logger)object2).setLevel(Level.INFO);
        Object object3 = ((Logger)object2).getHandlers();
        int n = ((Handler[])object3).length;
        for (int i = 0; i < n; ++i) {
            object = object3[i];
            ((Logger)object2).removeHandler((Handler)object);
        }
        if (this.fstandalone_) {
            try {
                object3 = new FileHandler(new File(file, "log.txt").toString());
                ((Handler)object3).setFormatter(new SimpleFormatter());
                ((Handler)object3).setLevel(Level.FINE);
                ((Logger)object2).addHandler((Handler)object3);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            object3 = new HandlerStream(System.out, new FormatterShort());
            ((Handler)object3).setLevel(Level.FINEST);
            ((Logger)object2).addHandler((Handler)object3);
        } else {
            for (Object object4 : object3 = new String[]{"com.pt", "phelps"}) {
                Logger.getLogger((String)object4).setUseParentHandlers(false);
            }
        }
        object2 = Multivalent.getLogger();
        ((Logger)object2).setLevel(this.loglevel_);
        ((Logger)object2).info(new StringBuffer().append("Multivalent ").append(VERSION).toString());
        ((Logger)object2).info(new StringBuffer().append("home site: ").append(HOME_SITE).toString());
        ((Logger)object2).config(new StringBuffer().append("home directory = ").append(string).toString());
        ((Logger)object2).config(new StringBuffer().append("cache directory = ").append(string4).toString());
        try {
            object3 = new HashMap(13);
            Enumeration<URL> enumeration = this.getClass().getClassLoader().getResources("sys/Preferences.txt");
            while (enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                if (object3.get(uRL) != null) continue;
                object3.put(uRL, uRL);
                this.readPreferences(uRL.openStream());
            }
        }
        catch (IOException iOException) {
            ((Logger)object2).warning(new StringBuffer().append("startup: ").append(iOException).toString());
        }
        this.defadaptor_ = (CHashMap)this.adaptor_.clone();
        this.defberemap_ = (HashMap)this.beremap_.clone();
        this.defpref_ = (CHashMap)this.pref_.clone();
        object3 = new File(file, FILENAME_PREFERENCES);
        if (((File)object3).exists()) {
            try {
                this.readPreferences(new FileInputStream((File)object3));
            }
            catch (IOException iOException) {
                ((Logger)object2).warning(new StringBuffer().append("couldn't read user prefs: ").append(iOException).toString());
            }
        }
        if (file.canWrite()) {
            try {
                this.cache_ = new CacheFile(file, new File(string));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.cache_ == null) {
            this.cache_ = Cache.NONE;
        }
    }

    public Cache getCache() {
        return this.cache_;
    }

    public String getGenre(String string, String string2) {
        String string3;
        String string4 = null;
        if (string != null) {
            int n = string.indexOf(59);
            if (n > 0) {
                string = string.substring(0, n).trim();
            }
            string4 = this.adaptor_.get(string);
        }
        String string5 = null;
        String string6 = Files.getSuffix(string2).toLowerCase();
        if (string5 == null && string2 != null) {
            string5 = this.adaptor_.get(string6);
        }
        if (string5 == null && (string3 = MIME.guessContentType(string2)) != null) {
            string5 = this.adaptor_.get(string3);
        }
        if (string5 == null && new File(string2).isDirectory()) {
            string5 = "DirectoryLocal";
        }
        if ((string4 == null || "text/plain".equals(string)) && string5 != null) {
            string4 = string5;
        }
        if (string4 == null && string6 == null) {
            string4 = this.adaptor_.get("text/plain");
        }
        if (string4 != null || string != null) {
            // empty if block
        }
        if (string4 == null) {
            string4 = this.adaptor_.get("text/plain");
        }
        Multivalent.getLogger().finest(new StringBuffer().append("genre: ").append(string).append(" / ").append(string2).append(" => ").append(string4).toString());
        return string4;
    }

    public Map<String, String> getGenreMap() {
        return this.adaptor_;
    }

    public static Logger getLogger() {
        return Logger.getLogger("multivalent");
    }

    public Timer getTimer() {
        if (this.timer_ == null) {
            this.timer_ = new Timer();
        }
        return this.timer_;
    }

    public String remapBehavior(String string) {
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        String string2 = this.beremap_.get(string);
        return string2 != null ? string2 : string;
    }

    public final String getPreference(String string, String string2) {
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        String string3 = this.pref_.get(string);
        if (string3 == null && string2 != null) {
            string3 = string2;
        }
        return string3;
    }

    public final void putPreference(String string, String string2) {
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        this.pref_.put(string, string2);
    }

    public final void removePreference(String string) {
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        this.pref_.remove(string);
    }

    public final Iterator<String> prefKeyIterator() {
        return this.pref_.keySet().iterator();
    }

    private void readPreferences(InputStream inputStream) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
        streamTokenizer.eolIsSignificant(true);
        streamTokenizer.resetSyntax();
        streamTokenizer.whitespaceChars(0, 32);
        streamTokenizer.wordChars(33, 126);
        streamTokenizer.commentChar(35);
        streamTokenizer.slashSlashComments(true);
        streamTokenizer.slashStarComments(true);
        streamTokenizer.quoteChar(34);
        try {
            int n = streamTokenizer.nextToken();
            while (n != -1) {
                if (n == 10) {
                    n = streamTokenizer.nextToken();
                    continue;
                }
                String string = streamTokenizer.sval;
                if (string != null) {
                    string = string.intern();
                }
                streamTokenizer.nextToken();
                String string2 = streamTokenizer.sval;
                streamTokenizer.nextToken();
                String string3 = streamTokenizer.sval;
                if ("mediaadaptor" == string) {
                    this.adaptor_.put(string2.toLowerCase(), string3);
                } else if ("remap" == string) {
                    this.beremap_.put(string2, string3);
                } else if ("set" == string) {
                    this.putPreference(string2, string3);
                }
                while ((n = streamTokenizer.nextToken()) != 10 && n != 59 && n != -1) {
                }
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            Multivalent.getLogger().warning(new StringBuffer().append("can't read prefs ").append(iOException).toString());
        }
    }

    private void writePreferences() {
        Multivalent.getLogger().info("writing preferences to cache");
        try {
            OutputStream outputStream = this.getCache().getOutputStream(null, FILENAME_PREFERENCES, "personal");
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
            bufferedWriter.write("# If line begins with '#', command is commented out\n\n\n");
            this.writePrefTable(bufferedWriter, this.adaptor_, this.defadaptor_, "mediaadaptor");
            bufferedWriter.write("# ... otherwise interpreted as ASCII\n\n\n");
            this.writePrefTable(bufferedWriter, this.beremap_, this.defberemap_, "remap");
            bufferedWriter.write("\n\n\n");
            this.writePrefTable(bufferedWriter, this.pref_, this.defpref_, "set");
            bufferedWriter.write("\n\n\n");
            ((Writer)bufferedWriter).close();
        }
        catch (IOException iOException) {
            Multivalent.getLogger().warning(new StringBuffer().append("Couldn't write Preferences: ").append(iOException).toString());
        }
    }

    private void writePrefTable(Writer writer, Map<String, String> map, Map<String, String> map2, String string) throws IOException {
        if (!($assertionsDisabled || writer != null && map != null && map2 != null && string != null)) {
            throw new AssertionError();
        }
        Object[] objectArray = map.keySet().toArray();
        Arrays.sort(objectArray);
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            String string2;
            String string3 = (String)objectArray[i];
            String string4 = map.get(string3);
            if (string4.equals(string2 = map2.get(string3))) {
                writer.write("#");
            }
            String string5 = string4.indexOf(32) == -1 ? "" : "\"";
            writer.write(new StringBuffer().append(string).append("\t").append(string3).append("\t").append(string5).append(string4).append(string5).append("\n").toString());
        }
    }

    public Browser getBrowser(String string) {
        return this.getBrowser(string, "System", true);
    }

    public Browser getBrowser(String string, String string2, boolean bl) {
        if (!$assertionsDisabled && string2 == null) {
            throw new AssertionError();
        }
        Browser browser = null;
        if (string != null && !"_NEW".equals(string)) {
            int n = this.browsers_.size();
            for (int i = 0; i < n; ++i) {
                Browser browser2 = this.browsers_.get(i);
                if (!string.equals(browser2.getName())) continue;
                browser = browser2;
                break;
            }
        }
        if (browser == null) {
            browser = new Browser(string, string2, bl);
            this.browsers_.add(browser);
            Multivalent.getLogger().fine(new StringBuffer().append("new browser instance '").append(string).append("'").toString());
        }
        return browser;
    }

    public Iterator<Browser> browsersIterator() {
        return this.browsers_.iterator();
    }

    void removeBrowser(Browser browser) {
        if (!$assertionsDisabled && this.browsers_.indexOf(browser) == -1) {
            throw new AssertionError();
        }
        this.browsers_.remove(browser);
        if (this.browsers_.size() == 0) {
            this.destroy();
        }
    }

    void destroy() {
        for (int i = this.browsers_.size() - 1; i >= 0; --i) {
            this.browsers_.get(i).destroy();
        }
        this.writePreferences();
        File file = new File(System.getProperty("java.io.tmpdir"));
        for (String string : file.list()) {
            if (!string.startsWith("imageio") || !string.endsWith(".tmp")) continue;
            new File(file, string).delete();
        }
        instance_ = null;
        if (this.fstandalone_) {
            System.exit(0);
        }
    }

    public static void main(String[] stringArray) {
        Multivalent multivalent = instance_ = new Multivalent();
        multivalent.fstandalone_ = true;
        multivalent.config();
        Browser browser = multivalent.getBrowser("STARTUP");
        browser.eventq("goHome", null);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        $assertionsDisabled = !(class$multivalent$Multivalent == null ? (class$multivalent$Multivalent = Multivalent.class$("multivalent.Multivalent")) : class$multivalent$Multivalent).desiredAssertionStatus();
        VERSION = (class$multivalent$Multivalent == null ? (class$multivalent$Multivalent = Multivalent.class$("multivalent.Multivalent")) : class$multivalent$Multivalent).getPackage().getSpecificationVersion();
        HOME_SITE = URI.create("http://multivalent.sourceforge.net/");
        instance_ = null;
        Multivalent.getLogger().setLevel(Level.OFF);
    }
}

