/*
 * Decompiled with CFR 0.152.
 */
package com.pt.io;

import com.pt.io.ObserverIO;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import phelps.io.InputStreams;
import phelps.util.Arrayss;

public class InputStreamTee
extends FilterInputStream {
    private OutputStream out_ = null;
    private byte[] buf_;
    private int bufi_ = 0;
    private int limit_ = 0;
    private long pos_ = 0L;
    private long mark_ = -1L;
    private int readlimit_ = -1;
    private boolean eof_ = false;
    private MessageDigest md_ = null;
    private byte[] digest_ = null;
    private List<Object> future_ = null;
    private long total_ = -1L;
    private long fillcnt_ = 0L;
    private List<ObserverIO> obs_ = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public InputStreamTee(InputStream inputStream, long l) {
        this(inputStream, l, null, null);
    }

    public InputStreamTee(InputStream inputStream, long l, String string, OutputStream outputStream) {
        super(inputStream);
        this.total_ = l;
        this.out_ = outputStream;
        if (string != null) {
            try {
                this.md_ = MessageDigest.getInstance(string);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        this.buf_ = new byte[8192];
    }

    InputStreamTee(byte[] byArray) {
        this(InputStreams.DEVNULL, byArray.length);
        this.buf_ = byArray;
        this.limit_ = byArray.length;
    }

    public int read() throws IOException {
        int n;
        if (this.bufi_ < this.limit_) {
            n = this.buf_[this.bufi_++] & 0xFF;
            ++this.pos_;
        } else if (this.eof_) {
            n = -1;
        } else {
            this.fill();
            n = this.read();
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.bufi_ < this.limit_) {
            n2 = Math.min(n2, this.limit_ - this.bufi_);
            System.arraycopy(this.buf_, this.bufi_, byArray, n, n2);
            this.bufi_ += n2;
            this.pos_ += (long)n2;
        } else if (this.eof_) {
            n2 = -1;
        } else {
            this.fill();
            n2 = this.read(byArray, n, n2);
        }
        return n2;
    }

    private void fill() throws IOException {
        int n = 0;
        int n2 = Math.min(8192, this.buf_.length);
        if (this.mark_ != -1L && this.mark_ + (long)this.readlimit_ > this.pos_) {
            long l = this.pos_ - (long)this.bufi_;
            if (!$assertionsDisabled && l % 4096L != 0L) {
                throw new AssertionError(l);
            }
            System.out.println("mark/reset " + this.mark_ + "..+" + this.readlimit_ + "  in " + l + ".." + this.pos_);
            int n3 = (int)((this.mark_ - l) / 4096L * 4096L);
            if (n3 > 0) {
                System.arraycopy(this.buf_, n3, this.buf_, 0, this.limit_ - n3);
                n = this.limit_ - n3;
                l += (long)n3;
            }
            System.out.println("\tshift <= " + n3);
            int n4 = (int)(this.mark_ + (long)this.readlimit_ - l);
            if (this.buf_.length < n4) {
                this.buf_ = Arrayss.resize(this.buf_, Math.min(102400, n4 + 4096 - n4 % 4096));
            }
            n2 = Math.min(n2, this.buf_.length - n);
            if (n4 > 0) {
                System.out.println("\textend by " + n4);
            }
        }
        while (true) {
            if ((n2 = this.in.read(this.buf_, n, n2)) > 0) {
                if (this.out_ != null) {
                    this.out_.write(this.buf_, n, n2);
                }
                if (this.md_ == null) break;
                this.md_.update(this.buf_, n, n2);
                break;
            }
            if (n2 != -1 || this.future_ == null || this.future_.size() == 0) break;
            Object object = this.future_.remove(0);
            if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                n2 = byArray.length;
                if (!$assertionsDisabled && n2 > this.buf_.length - n) {
                    throw new AssertionError();
                }
                System.arraycopy(byArray, 0, this.buf_, n, n2);
                break;
            }
            if (!$assertionsDisabled && !(object instanceof InputStream)) {
                throw new AssertionError();
            }
            this.in = (InputStream)object;
        }
        this.bufi_ = n;
        if (n2 >= 0) {
            this.limit_ = n + n2;
        } else {
            this.eof_ = true;
            this.limit_ = n;
            if (this.md_ != null) {
                this.digest_ = this.md_.digest();
            }
            this.md_ = null;
        }
        ++this.fillcnt_;
        this.report("available");
    }

    public synchronized void mark(int n) {
        this.mark_ = this.pos_;
        this.readlimit_ = n;
    }

    public synchronized void reset() throws IOException {
        long l = this.pos_ - this.mark_;
        if (l > (long)this.readlimit_) {
            throw new IOException("exceeded readlimit: " + l + " > " + this.readlimit_);
        }
        this.pos_ = this.mark_;
        this.bufi_ = (int)((long)this.bufi_ - l);
    }

    public boolean markSupported() {
        return true;
    }

    public int available() throws IOException {
        return this.limit_ - this.bufi_ + this.in.available();
    }

    public void close() throws IOException {
        if (this.out_ != null) {
            this.out_.close();
            this.out_ = null;
            super.close();
            this.report("close");
        }
    }

    public int peek() throws IOException {
        int n;
        if (this.bufi_ < this.limit_) {
            n = this.buf_[this.bufi_] & 0xFF;
        } else if (this.limit_ == -1) {
            n = -1;
        } else {
            this.fill();
            n = this.peek();
        }
        return n;
    }

    public void head(InputStream inputStream) {
        if (this.future_ == null) {
            this.future_ = new ArrayList<Object>(5);
        }
        this.future_.add(0, inputStream);
        if (this.bufi_ < this.limit_) {
            this.future_.add(Arrayss.subset(this.buf_, this.bufi_, this.limit_ - this.bufi_));
        }
        this.limit_ = this.bufi_;
        this.in = inputStream;
    }

    public void tail(InputStream inputStream) {
        if (this.future_ == null) {
            this.future_ = new ArrayList<Object>(5);
        }
        this.future_.add(inputStream);
    }

    public long getCount() {
        return this.pos_;
    }

    public long getTotal() {
        return this.total_;
    }

    public byte[] getDigest() {
        return this.digest_;
    }

    public void cancel() throws IOException {
        if (this.out_ != null) {
            this.close();
            this.report("cancel");
        }
    }

    public void addObserver(ObserverIO observerIO) {
        if (this.obs_ == null) {
            this.obs_ = new ArrayList<ObserverIO>(3);
        }
        if (!this.obs_.contains(observerIO)) {
            this.obs_.add(observerIO);
        }
    }

    private void report(String string) {
        if (this.obs_ != null) {
            int n = this.obs_.size();
            for (int i = 0; i < n; ++i) {
                this.obs_.get(i).update(this, string);
            }
        }
    }

    static {
        $assertionsDisabled = !InputStreamTee.class.desiredAssertionStatus();
    }
}

