/*
 * Decompiled with CFR 0.152.
 */
package com.pt.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import phelps.io.Files;
import phelps.lang.Strings;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileList {
    private static final boolean DEBUG = false;
    private FileFilter filter_;
    private List<File> base_ = new ArrayList<File>(30);
    private boolean fsort_ = true;
    private boolean fdirsfirst_ = false;
    private boolean frecurse_ = true;
    private boolean fsym_ = false;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$pt$io$FileList;

    public FileList(String string, FileFilter fileFilter) {
        this(new String[]{string}, fileFilter);
    }

    public FileList(String[] stringArray, FileFilter fileFilter) {
        this(stringArray, 0, fileFilter);
    }

    public FileList(String[] stringArray, int n, FileFilter fileFilter) {
        int n2 = stringArray.length;
        for (int i = n; i < n2; ++i) {
            this.addFile(stringArray[i]);
        }
        this.filter_ = fileFilter;
    }

    public FileList(File file, FileFilter fileFilter) {
        this(new File[]{file}, fileFilter);
    }

    public FileList(File[] fileArray, FileFilter fileFilter) {
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            this.addFile(fileArray[i]);
        }
        this.base_ = Arrays.asList((File[])fileArray.clone());
        this.filter_ = fileFilter;
    }

    public void addFile(File file) {
        if (!$assertionsDisabled && file == null) {
            throw new AssertionError();
        }
        this.base_.add(file);
    }

    public void addFile(String string) {
        if (string.startsWith("@")) {
            File file = Files.getFile(string.substring(1));
            if (file.canRead()) {
                try {
                    String string2;
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                    while ((string2 = bufferedReader.readLine()) != null) {
                        int n = string2.indexOf("//");
                        if (n >= 0) {
                            string2 = string2.substring(0, n);
                        }
                        if ((string2 = string2.trim()).length() == 0 || string2.startsWith("#")) continue;
                        this.addFile(Files.getFile(string2));
                    }
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            } else {
                this.addFile(file);
            }
        } else {
            this.addFile(Files.getFile(string));
        }
    }

    public void setSorted(boolean bl) {
        this.fsort_ = bl;
    }

    public void setDirsFirst(boolean bl) {
        this.fdirsfirst_ = bl;
    }

    public void setRecurse(boolean bl) {
        this.frecurse_ = bl;
    }

    public void setFollowSymbolic(boolean bl) {
        this.fsym_ = bl;
    }

    private boolean accept(File file) {
        return this.filter_ == null || this.filter_.accept(file);
    }

    private static void addPattern(List<File> list, File file) {
        String string = file.getName();
        if (string.endsWith("*") && file.getParentFile().exists()) {
            File file2 = file.getParentFile();
            string = string.substring(0, string.length() - 1);
            for (File file3 : file2.listFiles()) {
                if (!file3.getName().startsWith(string)) continue;
                list.add(file3);
            }
        }
    }

    public Iterator<File> iterator() {
        return this.depthFirstIterator();
    }

    public Iterator<File> depthFirstIterator() {
        return new Dfs();
    }

    public Iterator<File> breadthFirstIterator() {
        return new Bfs();
    }

    public File[] listFiles() {
        ArrayList<File> arrayList = new ArrayList<File>(100);
        File[] fileArray = this.iterator();
        while (fileArray.hasNext()) {
            arrayList.add(fileArray.next());
        }
        fileArray = arrayList.toArray(new File[arrayList.size()]);
        return fileArray;
    }

    public boolean delete() {
        boolean bl = true;
        Iterator<File> iterator = this.iterator();
        while (iterator.hasNext()) {
            File file = iterator.next();
            bl = file.delete() && bl;
        }
        return bl;
    }

    public void copy(File file) throws IOException {
        Iterator<File> iterator = this.iterator();
        while (iterator.hasNext()) {
            File file2 = iterator.next();
            File file3 = new File(file, file2.getPath());
            Files.copy(file2, file3);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static /* synthetic */ boolean access$000(FileList fileList) {
        return fileList.fsort_;
    }

    static /* synthetic */ boolean access$100(FileList fileList) {
        return fileList.fdirsfirst_;
    }

    static {
        $assertionsDisabled = !(class$com$pt$io$FileList == null ? (class$com$pt$io$FileList = FileList.class$("com.pt.io.FileList")) : class$com$pt$io$FileList).desiredAssertionStatus();
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Bfs
    implements Iterator<File> {
        List<File> q_ = new LinkedList<File>();
        File next_ = null;
        Comparator<File> comp_ = new FileOrder(FileList.access$000(FileList.this), FileList.access$100(FileList.this));

        Bfs() {
            int n = FileList.this.base_.size();
            for (int i = 0; i < n; ++i) {
                File file = (File)FileList.this.base_.get(i);
                if (file.exists()) {
                    this.q_.add(file);
                    continue;
                }
                FileList.addPattern(this.q_, file);
            }
        }

        @Override
        public boolean hasNext() {
            while (this.q_.size() > 0 && this.next_ == null) {
                File file = this.q_.remove(0);
                if (file.isDirectory()) {
                    if (file.canRead()) {
                        File[] fileArray = file.listFiles();
                        if (fileArray == null) continue;
                        Arrays.sort(fileArray, this.comp_);
                        for (File file2 : fileArray) {
                            if (file2.isDirectory() && FileList.this.frecurse_) {
                                try {
                                    if (!FileList.this.fsym_ && !file.toString().equals(file.getCanonicalFile().toString())) continue;
                                    this.q_.add(file2);
                                }
                                catch (IOException iOException) {}
                                continue;
                            }
                            if (!FileList.this.accept(file2)) continue;
                            this.q_.add(file2);
                        }
                    }
                    if (!FileList.this.accept(file)) continue;
                    this.next_ = file;
                    continue;
                }
                if (!file.exists()) continue;
                this.next_ = file;
            }
            return this.next_ != null;
        }

        @Override
        public File next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            File file = this.next_;
            this.next_ = null;
            return file;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public /* synthetic */ Object next() {
            return this.next();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Dfs
    implements Iterator<File> {
        List<File> q_ = new ArrayList<File>(100);
        File next_ = null;
        Comparator<File> comp_ = new FileOrder(FileList.access$000(FileList.this), FileList.access$100(FileList.this));

        Dfs() {
            for (int i = FileList.this.base_.size() - 1; i >= 0; --i) {
                File file = (File)FileList.this.base_.get(i);
                if (file.exists()) {
                    this.q_.add(file);
                    continue;
                }
                FileList.addPattern(this.q_, file);
            }
        }

        @Override
        public boolean hasNext() {
            while (this.q_.size() > 0 && this.next_ == null) {
                File file = this.q_.remove(this.q_.size() - 1);
                if (file.isDirectory()) {
                    if (file.canRead()) {
                        File[] fileArray = file.listFiles();
                        if (fileArray == null) continue;
                        Arrays.sort(fileArray, this.comp_);
                        for (int i = fileArray.length - 1; i >= 0; --i) {
                            File file2 = fileArray[i];
                            if (file2.isDirectory() && FileList.this.frecurse_) {
                                try {
                                    if (!FileList.this.fsym_ && !file.toString().equals(file.getCanonicalFile().toString())) continue;
                                    this.q_.add(file2);
                                }
                                catch (IOException iOException) {}
                                continue;
                            }
                            if (!FileList.this.accept(file2)) continue;
                            this.q_.add(file2);
                        }
                    }
                    if (!FileList.this.accept(file)) continue;
                    this.next_ = file;
                    continue;
                }
                if (!file.exists()) continue;
                this.next_ = file;
            }
            return this.next_ != null;
        }

        @Override
        public File next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            File file = this.next_;
            this.next_ = null;
            return file;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public /* synthetic */ Object next() {
            return this.next();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileOrder
    implements Comparator<File> {
        private boolean fsort_;
        private boolean fdirfirst_;

        FileOrder(boolean bl, boolean bl2) {
            this.fsort_ = bl;
            this.fdirfirst_ = bl2;
        }

        @Override
        public int compare(File file, File file2) {
            if (this.fdirfirst_) {
                boolean bl = file.isDirectory();
                boolean bl2 = file2.isDirectory();
                if (bl && !bl2) {
                    return -1;
                }
                if (!bl && bl2) {
                    return 1;
                }
            }
            if (this.fsort_) {
                return Strings.DICTIONARY_CASE_INSENSITIVE_ORDER.compare(file.getName(), file2.getName());
            }
            return 0;
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.compare((File)object, (File)object2);
        }
    }
}

