/*
 * Decompiled with CFR 0.152.
 */
package phelps.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import phelps.lang.Strings;

public class Version
implements Comparable {
    private static final Pattern REGEXP_PARSE = Pattern.compile("([0-9][^ \t\n\r\f-]*)");
    private static final Pattern REGEXP_ALLNUM = Pattern.compile("[0-9]+");
    private static final String[] VERSION_NONE = new String[]{"0"};
    private String version_;
    private String[] v_;

    public Version(String string) {
        this.version_ = string;
        Matcher matcher = REGEXP_PARSE.matcher(string);
        boolean bl = matcher.find();
        if (bl) {
            String string2 = matcher.group(1);
            ArrayList<String> arrayList = new ArrayList<String>(10);
            int n = string2.length();
            int n2 = 0;
            for (int i = 0; i <= n; ++i) {
                if (i == n) {
                    arrayList.add(string2.substring(n2));
                    continue;
                }
                if (string2.charAt(i) == '.') {
                    arrayList.add(string2.substring(n2, i));
                    n2 = i + 1;
                    continue;
                }
                if (i <= n2 || !(Character.isDigit(string2.charAt(i)) ^ Character.isDigit(string2.charAt(i - 1)))) continue;
                arrayList.add(string2.substring(n2, i));
                n2 = i;
            }
            this.v_ = arrayList.toArray(Strings.STRING0);
        } else {
            this.version_ = "0";
            this.v_ = VERSION_NONE;
        }
    }

    public Version(long l, long l2) {
        this.version_ = l + "." + l2;
        this.v_ = new String[]{Long.toString(l), Long.toString(l2)};
    }

    public Version(long l, long l2, long l3) {
        this.version_ = l + "." + l2 + "." + l3;
        this.v_ = new String[]{Long.toString(l), Long.toString(l2), Long.toString(l3)};
    }

    public int compareTo(Object object) {
        int n;
        if (object == null) {
            throw new NullPointerException();
        }
        if (!(object instanceof Version)) {
            throw new ClassCastException("can't compare " + object.getClass().getName() + " to phelps.util.Version");
        }
        int n2 = 0;
        String[] stringArray = this.v_;
        String[] stringArray2 = ((Version)object).v_;
        int n3 = stringArray.length;
        int n4 = stringArray2.length;
        int n5 = Math.min(n3, n4);
        for (n = 0; n < n5 && n2 == 0; ++n) {
            n2 = this.comparePart(stringArray[n], stringArray2[n]);
        }
        if (n2 == 0) {
            if (n3 < n4) {
                n = Character.toLowerCase(stringArray2[n3].charAt(0));
                n2 = n != 112 ? 1 : -1;
            } else if (n3 > n4) {
                n = Character.toLowerCase(stringArray[n4].charAt(0));
                n2 = n != 112 ? -1 : 1;
            }
        }
        return n2;
    }

    private int comparePart(String string, String string2) {
        int n = 0;
        boolean bl = Character.isDigit(string.charAt(0));
        boolean bl2 = Character.isDigit(string2.charAt(0));
        if (bl && bl2) {
            try {
                long l = Long.parseLong(string) - Long.parseLong(string2);
                n = l < 0L ? -1 : (l > 0L ? 1 : 0);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (!bl && bl2) {
            n = -1;
        } else if (bl && !bl2) {
            n = 1;
        }
        int n2 = string.length();
        int n3 = string2.length();
        int n4 = Math.min(n2, n3);
        for (int i = 0; i < n4 && n == 0; ++i) {
            n = Character.toLowerCase(string.charAt(i)) - Character.toLowerCase(string2.charAt(i));
        }
        if (n == 0) {
            n = n2 - n3;
        }
        return n < 0 ? -1 : (n > 0 ? 1 : 0);
    }

    public int compareTo(long l, long l2) {
        return this.compareTo(new Version(l, l2));
    }

    public int compareTo(long l, long l2, long l3) {
        return this.compareTo(new Version(l, l2, l3));
    }

    public static int compareTo(String string, String string2) {
        return new Version(string).compareTo(new Version(string2));
    }

    public boolean isCompatibleWith(Version version) {
        return this.comparePart(this.v_[0], version.v_[0]) == 0 && this.compareTo(version) <= 0;
    }

    public void setMin(Version version) {
        if (this.compareTo(version) < 0) {
            this.version_ = version.version_;
            this.v_ = version.v_;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Version)) {
            return false;
        }
        Version version = (Version)object;
        return Arrays.equals(this.v_, version.v_);
    }

    public String toString() {
        return this.version_;
    }
}

