/*
 * Decompiled with CFR 0.152.
 */
package multivalent;

import com.pt.io.InputUni;
import com.pt.io.InputUniString;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import multivalent.Behavior;
import multivalent.Document;
import multivalent.INode;
import multivalent.Layer;
import multivalent.Node;
import multivalent.SemanticEvent;
import multivalent.node.LeafUnicode;

public abstract class MediaAdaptor
extends Behavior {
    public static final int HINT_NONE = 0;
    public static final int HINT_METADATA_ONLY = 1;
    public static final int HINT_NO_TEXT = 4;
    public static final int HINT_NO_IMAGE = 8;
    public static final int HINT_NO_SHAPE = 16;
    public static final int HINT_NO_STYLE = 32;
    public static final int HINT_NO_TRANSCLUSION = 512;
    public static final int HINT_NO_LAYOUT = 1024;
    public static final int HINT_NO_SHOW = 2048;
    public static final int HINT_NO_INTERACTIVE = 4096;
    public static final int HINT_NORMALIZE = 32768;
    public static final int HINT_EXACT = 0x100000;
    public static final int HINT_FAST = 0x200000;
    public static final int HINT_DEFAULTS = 0;
    private InputUni iu_ = null;
    private float zoom_ = 1.0f;
    private int hints_ = 0;
    private boolean stop_ = false;
    private volatile boolean loading_ = true;

    public void setInput(InputUni inputUni) throws IOException {
        this.iu_ = inputUni;
    }

    public void setInput(File file) throws IOException {
        this.setInput(InputUni.getInstance(file, null));
    }

    protected InputUni getInputUni() {
        return this.iu_;
    }

    public URI getURI() {
        return this.iu_ != null ? this.iu_.getURI() : null;
    }

    public void setZoom(float f) {
        if (0.0f < f) {
            this.zoom_ = f;
        }
    }

    public float getZoom() {
        return this.zoom_;
    }

    public int getHints() {
        return this.hints_;
    }

    public void setHints(int n) {
        this.hints_ = n;
    }

    public abstract Object parse(INode var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object parseHelper(String string, String string2, Layer layer, INode iNode) {
        MediaAdaptor mediaAdaptor = (MediaAdaptor)Behavior.getInstance("helper", string2, null, layer);
        Node node = null;
        try {
            mediaAdaptor.setInput(new InputUniString(string, null));
            node = (Node)mediaAdaptor.parse(iNode);
        }
        catch (Exception exception) {
            new LeafUnicode("ERROR " + exception, null, iNode);
            exception.printStackTrace();
        }
        finally {
            try {
                mediaAdaptor.close();
            }
            catch (IOException iOException) {}
        }
        return node;
    }

    public boolean isAuthorized() {
        return true;
    }

    public void setPassword(String string) {
    }

    public synchronized boolean isStopped() {
        return this.stop_;
    }

    public synchronized void stop() {
        if (this.isStopped() && this.loading_) {
            this.stop_ = true;
            this.getDocument().putAttr("stop", "stop");
        }
    }

    public void close() throws IOException {
        if (this.iu_ != null) {
            this.iu_.close();
            this.iu_ = null;
        }
    }

    public void buildBefore(Document document) {
        try {
            this.parse(document);
        }
        catch (Exception exception) {
            new LeafUnicode("build before " + exception, null, document);
            exception.printStackTrace();
        }
    }

    public boolean semanticEventAfter(SemanticEvent semanticEvent, String string) {
        if ("stopDocument" == string && semanticEvent.getArg() == this.getDocument()) {
            MediaAdaptor.getLogger().fine("cancelling load: " + this.getURI());
            this.stop();
        } else if ("closeDocument" == string) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return super.semanticEventAfter(semanticEvent, string);
    }

    public void destroy() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.destroy();
    }
}

